VERSION 5.00
Begin VB.Form Data_load_form 
   Caption         =   "EM"
   ClientHeight    =   6780
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6465
   LinkTopic       =   "Form1"
   ScaleHeight     =   6780
   ScaleWidth      =   6465
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox Check_i 
      Caption         =   "Previously imputed values"
      Height          =   735
      Left            =   4080
      TabIndex        =   14
      Top             =   2760
      Width           =   2295
   End
   Begin VB.CheckBox Check_e 
      Caption         =   "Impute Errors"
      Height          =   495
      Left            =   2280
      TabIndex        =   13
      Top             =   2880
      Value           =   1  'Checked
      Width           =   1575
   End
   Begin VB.CheckBox Check_s 
      Caption         =   "Impute 'Suspect'"
      Height          =   495
      Left            =   480
      TabIndex        =   12
      Top             =   2880
      Value           =   1  'Checked
      Width           =   1695
   End
   Begin VB.TextBox show_file_name 
      Height          =   495
      Left            =   360
      TabIndex        =   10
      Top             =   3840
      Width           =   5655
   End
   Begin VB.CommandButton go_method 
      Caption         =   "EM"
      Height          =   1575
      Left            =   4920
      TabIndex        =   9
      Top             =   480
      Width           =   975
   End
   Begin VB.CommandButton Set_opt 
      Caption         =   "Set Options"
      Height          =   735
      Left            =   2280
      TabIndex        =   8
      Top             =   4800
      Width           =   1455
   End
   Begin VB.CommandButton view_data 
      Caption         =   "View Data"
      Height          =   735
      Left            =   480
      TabIndex        =   7
      Top             =   5760
      Width           =   1455
   End
   Begin VB.DriveListBox drive_set 
      Height          =   315
      Left            =   360
      TabIndex        =   4
      Top             =   2160
      Width           =   1095
   End
   Begin VB.CommandButton go_end 
      Caption         =   "Exit"
      Height          =   735
      Left            =   2280
      TabIndex        =   3
      Top             =   5760
      Width           =   1455
   End
   Begin VB.CommandButton go_calc 
      Caption         =   "Load Data"
      Height          =   735
      Left            =   480
      TabIndex        =   2
      Top             =   4800
      Width           =   1455
   End
   Begin VB.FileListBox File_set 
      Height          =   1845
      Left            =   2520
      TabIndex        =   1
      Top             =   480
      Width           =   1935
   End
   Begin VB.DirListBox Dir_set 
      Height          =   1440
      Left            =   360
      TabIndex        =   0
      Top             =   480
      Width           =   1815
   End
   Begin VB.Frame Frame1 
      Caption         =   "Working Directory"
      Height          =   2295
      Left            =   240
      TabIndex        =   5
      Top             =   240
      Width           =   2055
   End
   Begin VB.Frame file_frame 
      Caption         =   "Data (XML) file"
      Height          =   2295
      Left            =   2400
      TabIndex        =   6
      Top             =   240
      Width           =   2175
   End
   Begin VB.Frame Frame2 
      Caption         =   "Data File"
      Height          =   855
      Left            =   240
      TabIndex        =   11
      Top             =   3600
      Width           =   5895
   End
   Begin VB.Image Image1 
      Height          =   2265
      Left            =   3960
      Picture         =   "EM.frx":0000
      Top             =   4440
      Width           =   2400
   End
End
Attribute VB_Name = "Data_load_form"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Copyright NAG 2002

Private Sub Check_i_Click()
    If Check_i.Value = Checked Then
        mset = 1
        Check_s.Value = Checked
        Check_e.Value = Checked
    End If
    If Check_s.Value = Unchecked And mset = 1 Then
        mset = 2
    End If

End Sub

Private Sub Check_s_Click()
    If Check_s.Value = Checked Then
        mset = 2
        Check_e.Value = Checked
    End If
    If Check_s.Value = Unchecked And mset = 2 Then
        mset = 3
    End If
End Sub

Private Sub Check_e_Click()
    If Check_e.Value = Checked And mset > 3 Then
        mset = 3
    End If
    If Check_e.Value = Unchecked Then
        Check_s.Value = Unchecked
        mset = 4
    End If
End Sub

Private Sub Dir_set_Change()
Dim scratch As String
Dim l As Long
File_set.Path = Dir_set.Path
File_set.Pattern = "*.xml"
scratch = Dir_set.Path
l = Len(scratch)
If Right(scratch, 1) = "\" Then
    l = l - 1
End If
work_dir = Left(scratch, l)
End Sub

Private Sub drive_set_Change()
Dir_set.Path = drive_set.Drive
drive_set_up = drive_set.Drive
Call Dir_set_Change
End Sub



Private Sub File_set_Click()
Dim i As Long, j As Long
Dim linetext As String, scratch As String
data_file = File_set.FileName
work_dir = File_set.Path
If work_dir <> "" Then
    data_file = work_dir & "\" & data_file
End If
i = InStr(1, data_file, ".", 1)
xml_file = Left(data_file, i - 1) & ".xml"
r_file = Left(data_file, i - 1) & "_em_res.txt"
show_file_name.Text = xml_file
scratch = xml_file
On Error GoTo file_error
Open scratch For Input As #2
Line Input #2, linetxt
Line Input #2, linetxt
j = InStr(1, linetxt, "href=", 1)
k = InStr(1, linetxt, "?>", 1)
If j = 0 Or k = 0 Or k < j + 7 Then
    MsgBox ("Error in xml file")
    Close #2
    Exit Sub
End If
xsl_file = Mid(linetxt, j + 6, k - j - 7)
Line Input #2, linetxt
j = InStr(1, linetxt, "x-schema:", 1)
k = InStr(1, linetxt, ">", 1)
If j = 0 Or k = 0 Or k < j + 10 Then
    MsgBox ("Error in xml file")
    Close #2
    Exit Sub
End If
xdr_file = Mid(linetxt, j + 9, k - j - 10)
Close #2

Exit Sub
file_error:
    MsgBox (Err.Description)
    Close #2
End Sub

Private Sub Form_Load()
mset = 2
maxcat = 100
miss_val = -309931245.1
data_set = -1
opt_set = -1
min_wt = 0#
use_wts = 0
End Sub

Private Sub go_calc_Click()
Dim i As Long, k As Long
Dim info(1) As Long
Dim lname As nagstrg
Dim scratch As String
Call xml_data_size(xdr_file, n, m, maxname, info(0))

If info(0) <> 0 Then
    MsgBox ("Error in XDR file: " & Str$(info(0)) & " , " & Str$(info(1)))
End If
ReDim data(n * m)
ReDim swts(n)
ReDim n_cat(m)
ReDim cat_val(m * maxcat)
ReDim var_name(m)

For i = 0 To m - 1
    Call alloc_names(name_ptr, m, i, maxname)
Next i

Call xml_read(xml_file, xdr_file, miss_val, n, m, data(0), name_ptr, _
n_cat(0), cat_val(0), maxcat, mset, nmiss, info(0))

For i = 0 To m - 1
    Call get_names(name_ptr, i, lname)
    scratch = Left(lname.name, maxname + 7)
    k = InStr(1, scratch, "</name>", 1) - 1
    var_name(i) = Left(scratch, k)
Next i

Call free_list(name_ptr, m)

If info(0) <> 0 Then
    MsgBox ("Error in XML file")
Else
 MsgBox ("Data input complete")
End If

' Initialise options

data_set = 1
ReDim sx(m)
EM_options.var_list.Clear
var_num = 0
For i = 0 To m - 1
    sx(i) = 0
    If n_cat(i) > 0 Then
        EM_options.var_list.AddItem (var_name(i) & " (c)")
    Else
        EM_options.var_list.AddItem (var_name(i) & " (r)")
    End If
Next i
max_c = 20
tol = 0.000001
EM_options.set_c.Text = Str$(max_c)
EM_options.set_tol.Text = Str$(tol)

End Sub

Private Sub go_end_Click()
Dim i As Long, j As Long, k As Long
Dim scratch As String
If run_from_menu = 1 Then
    scratch = xml_file
    k = Len(scratch)
    i = 0
    For j = 1 To k
        If Mid(scratch, j, 1) = "\" Then
            i = j
        End If
    Next j
    If i > 0 Then
        xml_file = Right(scratch, k - i)
    End If
    eval_form.Visible = False
Else
    End
End If
End Sub


Private Sub go_method_Click()
Dim irow() As Long, icol() As Long
Dim rval() As Double
Dim nimp As Long, info(1) As Long
Dim i As Long

If data_set <> 1 Then
    MsgBox ("Data not loaded")
    Exit Sub
End If

opt_set = 1
If opt_set <> 1 Then
    MsgBox ("Options not set")
    Exit Sub
End If

ReDim irow(nmiss)
ReDim icol(nmiss)
ReDim rval(nmiss)

If use_wts = 0 Then
    Call em_alg(n, m, sx(0), data(0), miss_val, tol, max_c, 0, _
    nimp, irow(0), icol(0), rval(0), info(0))
Else
    Call em_wt(n, m, sx(0), data(0), miss_val, tol, max_c, swts(0), _
    nimp, irow(0), icol(0), rval(0), info(0))
End If
If info(0) <> 0 And info(0) < 20 Then
    MsgBox ("Error in imputation: " & Str$(info(0)) & " , " & Str$(info(1)))
    Exit Sub
End If
irow(nimp) = -1
icol(nimp) = -1

For i = 0 To nimp - 1
    data(irow(i) * m + icol(i)) = miss_val
Next i

Call xml_update(xml_file, xdr_file, xsl_file, miss_val, n, m, _
1, nimp, irow(0), icol(0), rval(0), info(0))

If info(0) <> 0 Then
    MsgBox ("Error updating XML file: " & Str$(info(0)) & " , " & Str$(info(1)))
    Exit Sub
End If

If EM_options.Check_r.Value = Checked Then
    Open r_file For Output Shared As #1
    Print #1, "<Number of Edits>"
    Print #1, Str$(nimp)
    Print #1, "<Start of Edits>"
    For i = 0 To nimp - 1
        Print #1, Str$(irow(i) + 1) & " " & Str$(icol(i) + 1) & " . " & Str$(rval(i))
    Next i
    Print #1, "<End of Edits>"
    Close #1
End If

MsgBox ("Imputation complete")

End Sub


Private Sub Set_opt_Click()
EM_options.Visible = True
End Sub

Private Sub show_file_name_Change()
xml_file = show_file_name.Text
data_set = 0
opt_set = 0
End Sub

Private Sub view_data_Click()
Call view_xml
End Sub
