/*
	Copyright (C) the University of Jyvskyl
	The Laboratory of Data Analysis

	NDA DLL interface
*/
#include "stdafx.h"
#include "ndadll.h"

HINSTANCE hNDALib = NULL;	/* DLL handle */

/* DLL function pointers */
LPFNDLLFUNC_nda_run_command nda_run_command;
LPFNDLLFUNC_nda_create_new_frame nda_create_new_frame;
LPFNDLLFUNC_nda_insert_ffield nda_insert_ffield;
LPFNDLLFUNC_nda_insert_ifield nda_insert_ifield;
LPFNDLLFUNC_nda_insert_sfield nda_insert_sfield;
LPFNDLLFUNC_nda_get_field_ptr nda_get_field_ptr;


int init_nda_dll(void)
/* initializes NDA DLL */
{
	hNDALib = LoadLibrary("nda.dll");
	if(hNDALib == NULL) return -1;

	/* extract DLL function pointers */
	nda_run_command = (LPFNDLLFUNC_nda_run_command)GetProcAddress(hNDALib,"run_NDA_command");
	if (!nda_run_command) return -1;

	nda_create_new_frame = (LPFNDLLFUNC_nda_create_new_frame)GetProcAddress(hNDALib,"create_new_frame");
	if (!nda_create_new_frame) return -1;
	
	nda_insert_ffield = (LPFNDLLFUNC_nda_insert_ffield)GetProcAddress(hNDALib,"nda_insert_ffield");
	if (!nda_insert_ffield) return -1;

	nda_insert_ifield = (LPFNDLLFUNC_nda_insert_ifield)GetProcAddress(hNDALib,"nda_insert_ifield");
	if (!nda_insert_ifield) return -1;

	nda_insert_sfield = (LPFNDLLFUNC_nda_insert_sfield)GetProcAddress(hNDALib,"nda_insert_sfield");
	if (!nda_insert_sfield) return -1;

	nda_get_field_ptr = (LPFNDLLFUNC_nda_get_field_ptr)GetProcAddress(hNDALib,"get_field_ptr");
	if (!nda_get_field_ptr) return -1;

	return 0;
}

int free_nda_dll(void)
/* frees NDA DLL */
{
	if(hNDALib != NULL) FreeLibrary(hNDALib); 
	return 0;
}

int run_nda_command(char *cmd)
/* runs NDA command */
{
	static char retbuf[4096];	/* return buffer */
	return nda_run_command(cmd, retbuf, 4096);
}
