# impute.cmd
# Does TS-SOM imputation
#
# input (must already exist in NDA's namespace):
# - data (input data)
# - sfr (variables' imputation (and edit) parameters data)
#
# input commandline parameters:
# $1 = TS-SOM dimension
# $2 = TS-SOM layer
# $3 = TS-SOM topology: 0=lattice, 1=ring, 2=TS-VQ (default 0)
# $4 = missing data value
# $5 = lower limit for cluster record count when classifying incomplete records (default 5)
# $6 = weighting of neighbours (default 0.5)
# $7 = stopping criteria (default 0.001)
# $8 = maximum number of iterations (default 20)
# $9 = number of corrected lookup layers (default 3)
# ${10} = training rule: 0=VQ, 1=spread (default 0)
# ${11} = use lookup table: 0=no,1=yes (default 1)
# ${12} = use fullsearch: 0=no,1=yes (default 0)
# ${13} = use Huber estimator: 0=no,1=yes
# ${14} = do outlier imputation: 0=no,1=yes [IGNORE]
# ${15} = Sigma2, affects to continuous variables error probabilities (default 1.0) [IGNORE]
# ${16} = Sigma1, training robustness parameter (default 3.0) [IGNORE]
#
# output (created to NDA's namespace):
# - output (imputed records)

# clean old data (if such present)
if -exist som -cmd rm som:
if -exist som_W -cmd rm som_W:
if -exist som_tinfo -cmd rm som_tinfo:
if -exist errors -cmd rm errors:
if -exist edata -cmd rm edata:
if -exist output -cmd rm output:

# do not use lookup ?
expr -fout _som_params -expr "";
if -expr ${11}=0; -cmd expr -fout _som_params -expr "${_som_params} -L";:

# use fullsearch ?
if -expr ${12}=1; -cmd expr -fout _som_params -expr "${_som_params} -F";:

# use Huber estimator ?
if -expr ${13}=1; -cmd expr -fout _som_params -expr "${_som_params} -H";:

serie -d data -fout refs.ref -start 0 -step 1

somtr -d data -D $1 -l $2 -t $3 -sout som -md $4 -icout output \
-eref refs -fstat sfr -tc -lim $5 -wght $6 -c $7 -m $8 -f $9 \
-r ${10} ${_som_params}

rm _som_params
rm refs
