/*
	Copyright (C) the University of Jyvskyl
	The Laboratory of Data Analysis
*/

/*** checking for error in return value ***/
#define Chk_err( rval ) \
{ \
  int _nda_chk_error_value = rval; \
  if( _nda_chk_error_value < 0 ) return( _nda_chk_error_value ); \
}

/*** name server errors ***/
#define	OPERATION_OK			0

/*** general errors ***/
#define	MALLOC_ERROR			-2
#define	PARAMETER_ERROR			-3
#define COMMAND_LINE_TOO_LONG		-5

/*** the name space ***/
#define	ENTRY_ALREADY_THERE		-100
#define	ENTRY_MALLOC_ERROR		-101
#define	ENTRY_NAME_MALLOC_ERROR		-102
#define	ENTRY_NOT_FOUND			-104
#define	NO_FRAME_FOUND			-105
#define	NO_ITEM_FOUND			-106
#define	POINTER_LIST_ALLOC_FAILED	-107
#define	PARENT_NOT_FRAME_TYPE		-109
#define	PARENT_IS_EMPTY			-110
#define	PARENT_DOES_NOT_POINT_US	-111
#define	CHILDREN_NOT_REFERENCED		-112
#define	REFERENCE_LIST_MALLOC_ERROR	-113
#define	ITEM_ALREADY_IN_FRAME		-114
#define	NOT_A_FRAME			-115
#define	NAME_SERVER_EMPTY		-116
#define	NOT_A_STRUCTURE			-117
#define	ENTRY_DOES_NOT_MATCH_DEFINITION	-118
#define	NOT_A_BASIC_ITEM_TYPE		-119
#define	UNKNOWN_TYPE			-120
#define	NO_DELETE_FUNCTION		-121
#define	NO_STRUCT_FOUND			-122
#define	NO_REFERENCES_TO_ITEM		-123
#define	ITEM_IS_REFERENCED		-124
#define NOT_ALLOWED_DELETION		-125

/* directories */
#define	NO_ROOT_DIRECTORY		-130
#define	INVALID_ENTRY_NAME		-131
#define NO_SUCH_DIRECTORY		-132
#define FILE_SYSTEM_ERROR       	-133
#define DIR_IS_NOT_EMPTY        	-134
#define PATHNAME_TOO_LONG               -135

/* process management */
#define NO_SUCH_PROCESS                 -140

/*** data server errors	***/
#define	FILE_READ_ERROR			-200
#define	INCORRECT_DATA_FRAME		-201
#define	CORRUPTED_DATA			-202
#define	ERROR_IN_DATA_LENGTH		-203
#define	NO_CLDATA			-204
#define	NO_CLASS			-205
#define	CLASS_DATA_TYPE_ERROR		-206
#define	NO_FRAME_TYPE			-207
#define	CLASS_INDEX_OVERFLOW		-208
#define	INCORRECT_DATA_TYPE		-209
#define	NO_DATA_FIELDS			-210
#define	INVALID_FIELD_NAME		-211
#define	INVALID_FIELD_VALUE		-212
#define EMPTY_CLASS                     -230
#define	DATA_AND_KEY_LEN_DIFFER		-250
#define TOO_MANY_CLASSES		-260

/*** file errors ***/
#define	UNEXP_EOF			-300
#define	UNEXP_EOL			-301
#define	INVALID_DATA_FIELD_COUNT	-302
#define	INVALID_DATA_REC_COUNT		-303
#define	NOT_NDA_DATA			-304
#define	DUPLICATE_FIELD_NAME		-305
#define	SAVE_OPEN_FAILED		-306
#define	WRONG_SAVE_FILE_TYPE		-307
#define	CANNOT_SAVE_FIELD_TYPE		-308
#define	NOT_OLD_DATA			-309
#define	DATA_NAME_NOT_SPECIFIED		-310
#define	CANNOT_WRITE_SOMFILE		-311
#define	CANNOT_READ_SOMFILE		-312
#define	NOT_A_DATA			-313
#define	NOT_A_CLDATA			-314
#define	NOT_A_TSSOM			-315
#define	TYPE_IS_CLDATA			-316
#define	TYPE_IS_DATA			-317
#define	TYPE_IS_OLDDATA			-318
#define	UNKNOW_DATA_TYPE		-319
#define	BATCH_FILE_OPEN_ERROR		-320
#define	TYPE_IS_FUZZYDATA		-321
#define	TYPE_IS_NOT_FUZZYDATA		-322
#define	NOT_TAB_DATA			-323
#define	FIELD_ITEM_IS_NULL		-324
#define	DONT_KNOW_HOW_TO_SAVE_TYPE	-325
#define	CANNOT_CONVERT_TO_GIVEN_TYPE	-326

/*** expression parsing ***/
#define P_PARSING_ERROR                 -402
#define P_DIVISION_BY_ZERO		-403
#define P_INVALID_NUM_OF_OPERAND	-405
#define P_NO_NAME_FOR_VARIABLE          -406
#define P_VARIABLE_NOT_FOUND            -407
#define P_INVALID_VARIABLE_LENGTH       -408
#define P_OPERAND_TYPE_MISMATCH         -409
#define P_UNKNOWN_TYPE                  -410
#define P_ILLEGAL_VALUE			-411

/* computing */
#define	NOT_BOOLEAN_EXPRESSION		-440

/*** comparing errors ***/
#define	TYPE_NOT_MATCH			-450
#define	KEY_COUNT_DOES_NOT_MATCH	-451
#define NO_CLASSES                      -480

/*** graphics ***/
#define	GRAPH_NPROTOS			-500
#define INCORRECT_GRAPH_TYPE 		-502
#define NO_TRAJ_INDEX                   -503
#define OUT_OF_RANGE                    -504
#define INVALID_FRAME_TYPE		-505

#define NO_SUCH_GRAPHIC_IN_FRAME	-515

#define NO_OBJECT_IN_POINT		-530
#define NO_OBJECT_IN_REGION		-531

#define NO_SUCH_FEATURE			-540

/*** fuzzy: error codes ***/
#define	NO_FUZZY_RANGES			-730
#define INVALID_FUZZYDATA		-731
#define	FUZZY_SET_EXISTS		-732
#define NO_FUZZY_SETS			-733
#define	NO_SUCH_FUZZY_SET		-734
#define	NO_SUCH_FUZZY_POINT		-735
#define INVALID_FUZZY_RANGE		-736
#define CANNOT_LOCK_DIFF_TYPES		-737
#define CANNOT_LOCK_GAUSS		-738
#define	FIELD_NOT_NUMERIC_TYPE		-740

/*** methods ***/
#define GENERAL_MATH_ERROR		-800
#define MISSING_PARAMETER_ERROR		-850

/*** messages -900 ... -949 reserved for SOM routines, check somserv/hdr.h ***/

/*** message handling ***/
#define UNKNOWN_COMMAND			-950

/*** temporal ***/
#define	NOT_IMPLEMENTED_YET		-999

/*** other ***/
#define INTERNAL_ERROR			-1000
#define INDEX_OVERFLOW			-1200
#define INVALID_THREAD_COUNT		-1201

/*** interrupt and return ***/
#define OPERATION_BREAK			-2000
#define MACRO_RETURN			-2001
#define MACRO_NAMING_ERROR		-2002
#define MACRO_BEGIN_ERROR		-2003
#define MACRO_END_ERROR			-2004
#define MACRO_ENDBEGIN_ERROR		-2005

/*** requested stop ***/
#define STOPPED				-9999

/*** error but do not print it ***/
#define IGNORE                          -10000
