#include <euredit_sys.h>


int main (int argc, char *argv[])
{
	/* Parameters */
	long        n = 200;
	long        m = 8;
	double     *data;
	long        n_cat[] = {0,0,0,0,0,0,0,0};
	long       *cat_val = NULL;
	long        maxcat = 0;
	double      miss_val = -999.0;
	long        nimp = 0;
	long       *irow;
	long       *icol;
	double     *rval;
	long        info[2];

	long         i, j, num_miss;
	const char   file[] = "continuous.dat";
	FILE        *fp;
	long        *iwork;


	/* Load data */
	if (!(data = (double *)malloc (n*m * sizeof (double))))
	{
		printf (" Memory allocation failure.\n");
		exit (2);
	}

	if ((fp = fopen (file, "r")) == NULL)
    {
		 printf (" Cannot open file named %s for reading.\n", file);
		 free (data);
		 exit (2);
	}

	num_miss = 0;
    for (i=0; i<n; ++i)
    {
		for (j=0; j<m; ++j)
        {
			fscanf(fp, "%lf", &data[i*m+j]);

			if (data[i*m+j] == miss_val) ++num_miss;
        }
        fscanf(fp, "\n");
    }
    fclose(fp);

	if (num_miss < 1)
	{
		printf (" No missing values to impute!.\n");
		free (data);
		exit (2);
	}
	else	
		printf (" Found %li missing values.\n", num_miss);


	/* Memory allocation */
	if (!(iwork = (long *)malloc (2*num_miss * sizeof (long))))
	{
		printf ("Memory allocation error.\n");
		exit (2);
	}
	irow = iwork;
	icol = irow + num_miss;

	if (!(rval = (double *)malloc (num_miss * sizeof (double))))
	{
		printf ("Memory allocation error.\n");
		exit (2);
	}

	/* Call simple imputation function */
	simp_imp (n,m,data,n_cat,cat_val,maxcat,miss_val,&nimp,irow,
		      icol,rval,info);

	if (info[0] > 0)
	{
		printf (" Error %ld in call to function simp_imp.\n", info[0]);
		free (data);
		free (iwork);
		free (rval);
		exit (2);
	}

	printf(" Number of Edits: %ld\n\n", nimp);
	printf(" <Start of Edits>\n");
    for (i=0; i<nimp; ++i)
    {
        j = icol[i];
        if (n_cat[j] == 0) 
        {
            printf(" %ld %ld %lf \n",irow[i],j,rval[i]);
        }
        else
        {
            printf(" %ld %ld %ld \n",irow[i],j,(long)rval[i]);
        }
    }
	printf(" <End of Edits>\n\n");

	free (data);
	free (iwork);
	free (rval);

	return 0;
}
