#include <euredit_sys.h>


int main (int argc, char *argv[])
{
	/* Parameters */
	char        dname[] = "Example categorical data";
	char        ifname[] = "categorical.dat";
	char        xmlfname[] = "categorical.xml";
	char        xslfname[] = "categorical.xsl";
	char        xdrfname[] = "categorical.xdr";
	long        n = 100;
	long        m = 8;
	long        del_type = 0;
	double      v_bound = -1;
	long        head = 0;
	char      **v_name;
	long        v_type[] = {2,2,2,2,2,2,3,3};
	long        n_cat[] = {100,2,2,2,3,5,10,11};
	long        cat_val[800];
	long        maxcat = 100;
	long        info[2];

	long        max_name_length = 6;
	long        base_cat[] = {1,1,1,1,1,1,0,0};
	long        i, j;

	
	if (!(v_name = (char **)malloc (m * sizeof (char *))))
	{
		printf (" Memory allocation failure.\n");
		exit (2);
	}

	/* Write variable names */
	for (i=0; i<m; ++i)
	{
		if (!(v_name[i] = (char *)malloc ((max_name_length+1)*sizeof(char))))
		{
			printf (" Memory allocation failure.\n");
			free (v_name);
			exit (2);
		}

		sprintf(v_name[i], "Var%li", i+1);
	}

	for (i=0; i<m; ++i)
	{
		for (j=0; j<n_cat[i]; ++j)
		{
			cat_val[i*maxcat+j] = base_cat[i] + j;
		}
	}

	/* Call data conversion component */
	data_conv (dname,ifname,xmlfname,xslfname,xdrfname,n,m,del_type,v_bound,
               head,v_name,v_type,n_cat,cat_val,maxcat,info);

	if (info[0] > 0)
	{
		printf (" Error %ld calling function data_conv.\n", info[0]);
	}

    exit (0);
}
