/*
 * ProcessThread.java
 *
 * Created on 09 April 2003, 15:54
 */
package euredit;
import javax.swing.*;
import java.util.*;
import java.io.*;

//import java.io.IOException;
//import java.io.File;
/**
 *
 * @author  mweeks
 * @version
 */
class StreamGobbler extends Thread
{
    InputStream is;
    OutputStream os;
    String type;
    
    StreamGobbler(InputStream is, String type)
    {
        this(is, type, null);
    }
    
    StreamGobbler(InputStream is, String type, OutputStream redirect)
    {
        this.is = is;
        this.type = type;
        this.os = redirect;
    }
    public void run0()
    {
        try
        {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line=null;
            while ( (line = br.readLine()) != null)
                System.out.println(type + ">" + line);    
        } 
        catch (IOException ioe)
        {
            ioe.printStackTrace();  
        }
    }
}

public class ProcessThread extends Thread {
  private JInternalFrame jFrame;
  private String specFileName;
  private Process p;
  /** Creates new ProcessThread */
  public ProcessThread(JInternalFrame jIntFrame, String specFile) {
    super();
    jFrame = jIntFrame;
    specFileName = specFile;
  }

  // Get shell program depending on the plateform    
  private static String getShell() {	    
    String shell;    	
    String osName = System.getProperty( "os.name" );	    
    if (osName.equals( "Windows 98" ) || osName.equals( "Windows 95" ) ) {		    
        shell = "command.com" ;	    
    }	    
    else {		    
        shell = "cmd.exe" ;	    
    }	    
    return shell;    
  }  
  
  public void run(){
    File dir = new File ("..\\");
    String command = getShell() + " /c " + "cmm.exe " + specFileName + " > " + "cmm_log.txt";
    //String command = getShell() + " /c " + dir + "cmm.exe " + specFileName + " > " + "cmm_log.txt";
    //String command = getShell() + " /c dir > " + "cmm_log.txt";
    JOptionPane.showMessageDialog(null, "Command passed to Dos (info only): " + command, " ", JOptionPane.ERROR_MESSAGE);
    if (p == null){
      try{
        FileOutputStream fos = new FileOutputStream("cmm_log.txt");
        //p = Runtime.getRuntime().exec(command, null, dir);
        p = Runtime.getRuntime().exec(command);
        StreamGobbler errorGobbler = new 
        StreamGobbler(p.getErrorStream(), "ERROR");            
            
        // any output?
        StreamGobbler outputGobbler = new 
        StreamGobbler(p.getInputStream(), "OUTPUT", fos);
                
        // kick them off
        errorGobbler.start();
        outputGobbler.start();
        
        fos.flush();
        fos.close();
                                            
        // any error???
        //int exitVal = p.waitFor();
        //System.out.println("ExitValue: " + exitVal);
      }
      catch(IOException i){
        JOptionPane.showMessageDialog(null, "IOException error " + i, "Spec File error - " + specFileName, JOptionPane.ERROR_MESSAGE);
      }
      try {
        int exitVal = p.waitFor();
        System.out.println("ExitValue: " + exitVal);
      }
      catch (InterruptedException i){
        if (p != null)
          p.destroy();
      }
      if (p != null){
        p.destroy();
        jFrame.setVisible(false);
        JOptionPane.showMessageDialog(null, "Processing Completed.", "Please close the java application", JOptionPane.ERROR_MESSAGE);
      }
    }
  }
}