(* Custom Proof Contexts for utp-lang. *)

(* Utility Functions *)

fun z_make_prove_tac thms =
	fn (args) => z_basic_prove_tac (args @ thms);

(* Component Proof Context 'utp_lang_rw *)

delete_pc "'utp_lang_rw" handle Fail _ => ();
new_pc "'utp_lang_rw";
add_rw_thms [NAME_spec] "'utp_lang_rw";
add_rw_thms [ALPHABET_spec] "'utp_lang_rw";
add_rw_thms [dashed_spec] "'utp_lang_rw";
add_rw_thms [undashed_spec] "'utp_lang_rw";
add_rw_thms [dashed_once_spec] "'utp_lang_rw";

val utp_lang_pr_thms = [dash_spec, in_a_spec, out_a_spec];

set_pr_tac (z_make_prove_tac utp_lang_pr_thms) "'utp_lang_rw";
commit_pc "'utp_lang_rw";

(* Proof Context utp_lang_sets *)

delete_pc "utp_lang_sets" handle Fail _ => ();
new_pc "utp_lang_sets";
merge_pcs ["z_sets_ext", "'utp_lang_rw"] "utp_lang_sets";
commit_pc "utp_lang_sets";

(* Proof Context utp_lang_fun *)

delete_pc "utp_lang_fun" handle Fail _ => ();
new_pc "utp_lang_fun";
merge_pcs ["z_fun_ext", "'utp_lang_rw"] "utp_lang_fun";
commit_pc "utp_lang_fun";
