/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.utils;

import java.util.Collection;
import java.util.List;
import java.util.Set;

public class StringUtils {
    public static String escape(String string) {
        string = string.replace("\\", "\\\\");
        string = string.replace("\n", "\\n");
        string = string.replace("\r", "\\r");
        string = string.replace("\t", "\\t");
        string = string.replace("\b", "\\b");
        string = string.replace("\f", "\\f");
        string = string.replace("\"", "\\\"");
        string = string.replace("'", "\\'");
        return string;
    }

    public static String unescape(String string) {
        string = string.replace("\\\\", "\\");
        string = string.replace("\\n", "\n");
        string = string.replace("\\r", "\r");
        string = string.replace("\\t", "\t");
        string = string.replace("\\b", "\b");
        string = string.replace("\\f", "\f");
        string = string.replace("\\\"", "\"");
        string = string.replace("\\'", "'");
        return string;
    }

    public static String quote(String string) {
        return "\"" + StringUtils.escape(string) + "\"";
    }

    public static String unquote(String string) {
        assert (string.charAt(0) == '\"');
        assert (string.charAt(string.length() - 1) == '\"');
        return StringUtils.unescape(StringUtils.removeQuotes(string));
    }

    public static String addQuotes(String string) {
        return '\"' + string + '\"';
    }

    public static String removeQuotes(String string) {
        assert (string.charAt(0) == '\"');
        assert (string.charAt(string.length() - 1) == '\"');
        return string.substring(1, string.length() - 1);
    }

    public static String joinQuoted(String string, String string2) {
        return StringUtils.addQuotes(StringUtils.removeQuotes(string) + StringUtils.removeQuotes(string2));
    }

    public static <T> String toString(Collection<T> collection, String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        boolean bl = true;
        for (T t : collection) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string3);
            }
            stringBuilder.append(t);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static <T> String toString(List<T> list) {
        return StringUtils.toString(list, "<", ">", ", ");
    }

    public static <T> String toString(Set<T> set) {
        return StringUtils.toString(set, "{", "}", ", ");
    }
}

