/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.zeyda.clawcircus.Data.ClawZ.LibraryMetaFile;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.utils.ParserUtils;

public class FileUtils {
    public static String readTextFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            FileReader fileReader = new FileReader(string);
            while ((n = fileReader.read()) != -1) {
                stringBuilder.append((char)n);
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + string);
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            System.exit(-1);
        }
        return stringBuilder.toString();
    }

    public static String readDataFile(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            while ((n = bufferedInputStream.read()) != -1) {
                stringBuilder.append((char)n);
            }
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("File not found: " + string);
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            System.exit(-1);
        }
        return stringBuilder.toString();
    }

    public static void writeTextFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2);
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            System.exit(-1);
        }
    }

    public static void writeDataFile(String string, String string2) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            for (int i = 0; i < string2.length(); ++i) {
                bufferedOutputStream.write(string2.charAt(i));
            }
            bufferedOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println(iOException.toString());
            System.exit(-1);
        }
    }

    public static MdlBlock readMdl(String string) {
        String string2 = FileUtils.readTextFile(string);
        MdlBlock mdlBlock = ParserUtils.parseMdl(string2);
        return mdlBlock;
    }

    public static void writeMdl(String string, MdlBlock mdlBlock) {
        FileUtils.writeTextFile(string, mdlBlock.serialise() + "\n");
    }

    public static LibraryMetaFile readLmf(String string) {
        String string2 = FileUtils.readDataFile(string);
        LibraryMetaFile libraryMetaFile = ParserUtils.parseLmf(string2);
        return libraryMetaFile;
    }

    public static void writeLmf(String string, LibraryMetaFile libraryMetaFile) {
        FileUtils.writeDataFile(string, libraryMetaFile.serialise() + "\n");
    }
}

