/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.utils;

import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.Enabled;
import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortBlock;
import org.zeyda.clawcircus.Data.Diagram.PortDir;
import org.zeyda.clawcircus.Data.Diagram.ResolveMethod;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockWiringXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.FlowXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.PortRangeXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.PortSpecXml;
import org.zeyda.clawcircus.Toolbox.ClaSPLibrary;
import org.zeyda.clawcircus.collections.FlowSet;
import org.zeyda.clawcircus.collections.SignalList;
import org.zeyda.clawcircus.collections.SignalSet;
import org.zeyda.clawcircus.collections.impl.FlowSetImpl;
import org.zeyda.clawcircus.collections.impl.SignalListImpl;
import org.zeyda.clawcircus.collections.impl.SignalSetImpl;
import org.zeyda.clawcircus.utils.MiscUtils;
import org.zeyda.clawcircus.utils.StringUtils;

public class ClaSPUtils {
    public static BlockWiring calcBlockWiringFromLib(Block block) {
        BlockWiringXml blockWiringXml = ClaSPLibrary.getBlockWiring(block.getBlockType());
        if (blockWiringXml == null) {
            throw new IllegalArgumentException("Couldn't generate BlockWiring for Block: " + block.toString());
        }
        SignalList signalList = ClaSPUtils.generateInps(blockWiringXml, block);
        SignalList signalList2 = ClaSPUtils.generateOuts(blockWiringXml, block);
        FlowSet flowSet = ClaSPUtils.generateFlows(blockWiringXml, block);
        return new BlockWiring(signalList, signalList2, flowSet);
    }

    private static SignalList generateInps(BlockWiringXml blockWiringXml, Block block) {
        SignalListImpl signalListImpl = new SignalListImpl();
        String string = blockWiringXml.getInps();
        if (string != null) {
            string = string.trim().toLowerCase();
            assert (string.equals("varlength") || MiscUtils.canBeParsedAsInt(string));
            int n = string.equals("varlength") ? block.getInputPortsNum() : Integer.parseInt(string);
            if (block.getInputPortsNum() != n) {
                throw new AssertionError((Object)"Inconsistency in number of input ports: ClaSP block library vs. actual inputs of instantiated Block.");
            }
            for (int i = 1; i <= n; ++i) {
                if (block.getInputPort(i).isConnected()) {
                    signalListImpl.add(block.getInputPort(i).getLink().getSignal());
                    continue;
                }
                signalListImpl.add(null);
            }
        }
        return signalListImpl;
    }

    private static SignalList generateOuts(BlockWiringXml blockWiringXml, Block block) {
        SignalListImpl signalListImpl = new SignalListImpl();
        String string = blockWiringXml.getOuts();
        if (string != null) {
            string = string.trim().toLowerCase();
            assert (string.equals("varlength") || MiscUtils.canBeParsedAsInt(string));
            int n = string.equals("varlength") ? block.getOutputPortsNum() : Integer.parseInt(string);
            if (block.getOutputPortsNum() != n) {
                System.out.println(block.toString());
                throw new AssertionError((Object)"Inconsistency in number of output ports: ClaSP block library vs. actual outputs of instantiated Block.");
            }
            for (int i = 1; i <= n; ++i) {
                if (block.getOutputPort(i).isConnected()) {
                    signalListImpl.add(block.getOutputPort(i).getLink().getSignal());
                    continue;
                }
                signalListImpl.add(null);
            }
        }
        return signalListImpl;
    }

    private static FlowSet generateFlows(BlockWiringXml blockWiringXml, Block block) {
        FlowSetImpl flowSetImpl = new FlowSetImpl();
        for (FlowXml flowXml : blockWiringXml.getFlows().getFlow()) {
            flowSetImpl.add(ClaSPUtils.generateFlow(flowXml, block));
        }
        return flowSetImpl;
    }

    private static Flow generateFlow(FlowXml flowXml, Block block) {
        Enabled enabled = ClaSPUtils.getEnabled(flowXml, block);
        boolean bl = ClaSPUtils.getOrdered(flowXml, block);
        SignalSet signalSet = ClaSPUtils.getRInps(flowXml, block);
        SignalSet signalSet2 = ClaSPUtils.getPOuts(flowXml, block);
        return new Flow(enabled, bl, signalSet, signalSet2);
    }

    private static Enabled getEnabled(FlowXml flowXml, Block block) {
        if (flowXml.getEnabled().isAlways()) {
            return Enabled.ALWAYS;
        }
        return new Enabled(ClaSPUtils.getSignals(flowXml.getEnabled(), block, PortDir.INPUT));
    }

    private static boolean getOrdered(FlowXml flowXml, Block block) {
        return flowXml.isOrdered();
    }

    private static SignalSet getRInps(FlowXml flowXml, Block block) {
        return ClaSPUtils.getSignals(flowXml.getRinps(), block, PortDir.INPUT);
    }

    private static SignalSet getPOuts(FlowXml flowXml, Block block) {
        return ClaSPUtils.getSignals(flowXml.getPouts(), block, PortDir.OUTPUT);
    }

    private static SignalSet getSignals(PortSpecXml portSpecXml, Block block, PortDir portDir) {
        Port port;
        int n;
        Object object;
        Object object2;
        SignalSetImpl signalSetImpl = new SignalSetImpl();
        Iterator<Object> iterator = portSpecXml.getPort().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.next();
            object2 = ClaSPUtils.getPort(block, n2, portDir);
            if (!((Port)object2).isConnected()) continue;
            signalSetImpl.add(((Port)object2).getLink().getSignal());
        }
        for (JAXBElement jAXBElement : portSpecXml.getPortList()) {
            object2 = (List)jAXBElement.getValue();
            object = object2.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                port = ClaSPUtils.getPort(block, n, portDir);
                if (!port.isConnected()) continue;
                signalSetImpl.add(port.getLink().getSignal());
            }
        }
        for (PortRangeXml portRangeXml : portSpecXml.getPortRange()) {
            object2 = portRangeXml.getFrom();
            if (object2 == null) {
                object2 = 1;
            }
            if ((object = portRangeXml.getTo()) == null) {
                switch (portDir) {
                    case INPUT: {
                        object = block.getInputPortsNum();
                        break;
                    }
                    case OUTPUT: {
                        object = block.getOutputPortsNum();
                    }
                }
            }
            for (n = ((Integer)object2).intValue(); n <= (Integer)object; ++n) {
                port = ClaSPUtils.getPort(block, n, portDir);
                if (!port.isConnected()) continue;
                signalSetImpl.add(port.getLink().getSignal());
            }
        }
        iterator = portSpecXml.getPortPattern().iterator();
        if (iterator.hasNext()) {
            String string = (String)iterator.next();
            throw new AssertionError((Object)"Processing of <portPattern>..</portPattern> not supported yet.");
        }
        return signalSetImpl;
    }

    private static Port getPort(Block block, int n, PortDir portDir) {
        switch (portDir) {
            case INPUT: {
                return block.getInputPort(n);
            }
            case OUTPUT: {
                return block.getOutputPort(n);
            }
        }
        throw new AssertionError();
    }

    public static Signal getSignalFromPort(Port port, ResolveMethod resolveMethod) {
        Signal signal = null;
        switch (resolveMethod) {
            case INTERNAL: {
                assert (port.getBlock().isSubSystem());
                PortBlock portBlock = ((SubSystem)port.getBlock()).resolveIntoBlock(port);
                if (portBlock == null) break;
                signal = portBlock.getSignal();
                break;
            }
            case EXTERNAL: {
                if (!port.isConnected()) break;
                signal = port.getLink().getSignal();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return signal;
    }

    public static void printClaSPModel(SubSystem subSystem) {
        System.out.println("[ClaSP Model]");
        System.out.println(" SubSystem: " + subSystem.getPath());
        for (Block block : subSystem) {
            if (!block.getClass().getName().startsWith("org.zeyda.clawcircus.Data.Diagram.BlockTypesGen")) continue;
            System.out.println("---");
            System.out.print("Block: " + StringUtils.quote(block.getName()));
            System.out.print(" (" + block.getBlockType() + ")");
            System.out.println();
            BlockWiring blockWiring = block.getBlockWiring();
            if (blockWiring == null) {
                throw new AssertionError((Object)("BlockType " + block.getBlockType() + " not in ClaSP library as it should."));
            }
            System.out.print(blockWiring.toString());
        }
        for (Block block : subSystem) {
            if (!block.isSubSystem()) continue;
            System.out.println();
            ClaSPUtils.printClaSPModel((SubSystem)block);
        }
    }
}

