/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.UI;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Toolbox.TranslationStrategy;
import org.zeyda.clawcircus.UI.BlockTreeModel;
import org.zeyda.clawcircus.utils.StringUtils;

public class JBlockTree
extends JTree {
    public JBlockTree(Block block) {
        super(new BlockTreeModel(block));
        block.setAnnotation(TreeModel.class, this.getModel());
        this.addTreeExpansionListener(new BlockTreeExpansionListener());
        block.updateUI();
    }

    public BlockTreeModel getBlockTreeModel() {
        return (BlockTreeModel)super.getModel();
    }

    public Block getRoot() {
        assert (this.getModel().getRoot() instanceof Block);
        return (Block)this.getModel().getRoot();
    }

    public Block getSelectedBlock() {
        if (!this.isSelectionEmpty()) {
            return (Block)this.getSelectionPath().getLastPathComponent();
        }
        return null;
    }

    @Override
    protected TreeModelListener createTreeModelListener() {
        return new BlockTreeModelListener();
    }

    @Override
    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object instanceof Block) {
            Block block = (Block)object;
            return StringUtils.escape(block.getName()) + " (" + block.getBlockType() + ")";
        }
        return super.convertValueToText(object, bl, bl2, bl3, n, bl4);
    }

    public void finalize() {
        this.getRoot().removeAnnotation(TreeModel.class);
    }

    class BlockTreeExpansionListener
    implements TreeExpansionListener {
        BlockTreeExpansionListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            Block block = (Block)treeExpansionEvent.getPath().getLastPathComponent();
            if (block instanceof SubSystem) {
                ((SubSystem)block).setTranslationStrategy(TranslationStrategy.CENTRALISED);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Block block = (Block)treeExpansionEvent.getPath().getLastPathComponent();
            if (block instanceof SubSystem) {
                ((SubSystem)block).setTranslationStrategy(TranslationStrategy.PARALLEL);
            }
        }
    }

    class BlockTreeModelListener
    extends JTree.TreeModelHandler {
        BlockTreeModelListener() {
            super(JBlockTree.this);
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            Block block = (Block)treeModelEvent.getTreePath().getLastPathComponent();
            if (block.isSubSystem()) {
                if (((SubSystem)block).isCentralised() && !JBlockTree.this.isCollapsed(treeModelEvent.getTreePath())) {
                    JBlockTree.this.collapsePath(treeModelEvent.getTreePath());
                }
                if (((SubSystem)block).isParallel() && !JBlockTree.this.isExpanded(treeModelEvent.getTreePath())) {
                    JBlockTree.this.expandPath(treeModelEvent.getTreePath());
                }
            }
        }
    }
}

