/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.UI;

import java.util.Collections;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.BlockComparator;
import org.zeyda.clawcircus.collections.BlockList;

public class BlockTreeModel
implements TreeModel {
    public static final boolean DEFAULT_HIDEPORTS = true;
    protected Block root;
    protected EventListenerList listeners;
    protected boolean hide_ports;

    public BlockTreeModel(Block block) {
        assert (block != null);
        this.root = block;
        this.listeners = new EventListenerList();
        this.setHidePorts(true);
    }

    public boolean getHidePorts() {
        return this.hide_ports;
    }

    public void setHidePorts(boolean bl) {
        this.hide_ports = bl;
        for (TreeModelListener treeModelListener : (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class)) {
            treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this.root, this.root.getTreePath()));
        }
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        assert (object instanceof Block);
        BlockList blockList = this.reorderBlockList(((Block)object).getChildren());
        return blockList.get(n);
    }

    @Override
    public int getChildCount(Object object) {
        assert (object instanceof Block);
        BlockList blockList = this.reorderBlockList(((Block)object).getChildren());
        return blockList.size();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        assert (object instanceof Block);
        BlockList blockList = this.reorderBlockList(((Block)object).getChildren());
        return blockList.indexOf(object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        assert (object instanceof Block);
        return !((Block)object).isSubSystem();
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        for (TreeModelListener treeModelListener : (TreeModelListener[])this.listeners.getListeners(TreeModelListener.class)) {
            treeModelListener.treeNodesChanged(new TreeModelEvent(object, treePath));
        }
    }

    protected BlockList reorderBlockList(BlockList blockList) {
        BlockList blockList2 = (BlockList)blockList.clone();
        Collections.sort(blockList2, new BlockComparator());
        if (this.hide_ports) {
            Iterator iterator = blockList2.iterator();
            while (iterator.hasNext()) {
                Block block = (Block)iterator.next();
                if (!block.isPort()) continue;
                iterator.remove();
            }
        }
        return blockList2;
    }
}

