/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox.st;

import java.util.ArrayList;
import java.util.List;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Path;
import org.zeyda.clawcircus.utils.DiagramUtils;
import org.zeyda.clawcircus.utils.LatexUtils;

public class StateInfoConnector {
    public final String STATE_SUFFIX = "_state";
    private final Block root;
    private final Block block;

    public StateInfoConnector(Block block, Block block2) {
        assert (block != null);
        assert (block2 != null);
        assert (block2.getProperty("state", Boolean.class).booleanValue());
        this.root = block;
        this.block = block2;
    }

    public String getBlock() {
        return LatexUtils.encode(this.block.getClawZName());
    }

    public String getUnprimed() {
        return this.getBlock() + LatexUtils.encode("_state");
    }

    public String getPrimed() {
        return this.getUnprimed() + "'";
    }

    public String getSelect_stmt() {
        Path path = this.block.getPath().subtract(this.root.getPath());
        assert (this.block.getPath().size() == this.root.getPath().size() + path.size());
        if (path.isEmpty()) {
            return null;
        }
        return LatexUtils.encode(path.getZSelectionStmt());
    }

    public String getType() {
        return "\\universe";
    }

    public static List<StateInfoConnector> createList(Block block) {
        ArrayList<StateInfoConnector> arrayList = new ArrayList<StateInfoConnector>();
        for (Block block2 : DiagramUtils.getSubordinateBlocksWithState(block)) {
            assert (block2.getProperty("state", Boolean.class).booleanValue());
            arrayList.add(new StateInfoConnector(block, block2));
        }
        return arrayList;
    }
}

