/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox.st;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortDir;
import org.zeyda.clawcircus.utils.LatexUtils;
import org.zeyda.clawcircus.utils.TransUtils;

public class SignalConnector {
    private final Signal signal;
    private final Port port;

    public SignalConnector(Signal signal) {
        assert (signal != null);
        this.signal = signal;
        this.port = null;
    }

    public SignalConnector(Signal signal, Port port) {
        assert (signal != null);
        assert (port != null);
        this.signal = signal;
        this.port = port;
    }

    private boolean hasPort() {
        return this.port != null;
    }

    public String getName() {
        return LatexUtils.encode(this.signal.getName());
    }

    public String getLifted() {
        return LatexUtils.encode(this.signal.lift().getName());
    }

    public String getVar() {
        assert (this.hasPort());
        return LatexUtils.encode(TransUtils.getVar(this.port));
    }

    public String getDecovar() {
        assert (this.hasPort());
        return LatexUtils.encode(TransUtils.getDecoVar(this.port));
    }

    public static List<SignalConnector> createList(Collection<Signal> collection) {
        assert (collection != null);
        LinkedList<SignalConnector> linkedList = new LinkedList<SignalConnector>();
        for (Signal signal : collection) {
            if (signal != null) {
                linkedList.add(new SignalConnector(signal));
                continue;
            }
            linkedList.add(null);
        }
        return linkedList;
    }

    public static List<SignalConnector> createList(List<Signal> list, Block block, PortDir portDir) {
        assert (list != null);
        LinkedList<SignalConnector> linkedList = new LinkedList<SignalConnector>();
        int n = 1;
        for (Signal signal : list) {
            if (signal != null) {
                linkedList.add(new SignalConnector(signal, new Port(block, n, portDir)));
            } else {
                linkedList.add(null);
            }
            ++n;
        }
        return linkedList;
    }
}

