/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox;

import java.util.LinkedList;
import org.zeyda.clawcircus.Data.ClawZ.LibraryMetaFile;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Data.Simulink.MdlElement;
import org.zeyda.clawcircus.Toolbox.BlockInfoTag;
import org.zeyda.clawcircus.utils.PrintUtils;

public class SimulinkAnalyser {
    public static final int SPACES_PER_TAB = 2;
    private static boolean USE_COLOURED_OUTPUT = false;
    public static final String[] DEFAULT_TRANSLATABLE_BLOCKS = new String[]{"Inport", "Outport", "EnablePort", "Constant", "Terminator", "Mux", "Demux"};
    protected LibraryMetaFile[] lmfs;

    public SimulinkAnalyser(LibraryMetaFile[] libraryMetaFileArray) {
        this.lmfs = libraryMetaFileArray;
    }

    public static void invoke(MdlBlock mdlBlock, LibraryMetaFile[] libraryMetaFileArray) {
        new SimulinkAnalyser(libraryMetaFileArray).invoke(mdlBlock);
    }

    private void invoke(MdlBlock mdlBlock) {
        MdlBlock mdlBlock2 = mdlBlock.getBlock("System");
        if (mdlBlock2 == null) {
            System.out.println("System block not present, no analysis performed.");
            return;
        }
        this.analyseSystem(mdlBlock2);
    }

    private void analyseSystem(MdlBlock mdlBlock) {
        this.analyseSystem(mdlBlock, 0);
    }

    private void analyseSystem(MdlBlock mdlBlock, int n) {
        MdlBlock mdlBlock2;
        assert (mdlBlock.getName().equals("System"));
        if (n == 0) {
            this.printBlockInfo("System", mdlBlock.getAttributeValue("Name"), n);
        } else {
            System.out.println(this.getIndentSpace(n) + "---");
            this.printBlockInfo("SubSystem", mdlBlock.getAttributeValue("Name"), n);
        }
        LinkedList<MdlBlock> linkedList = new LinkedList<MdlBlock>();
        for (MdlElement mdlElement : mdlBlock) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals("Block") || !(mdlBlock2 = (MdlBlock)mdlElement).isBlockType("Inport")) continue;
            this.analyseBlock(mdlBlock2, n + 1);
            linkedList.add(mdlBlock2);
        }
        System.out.println(this.getIndentSpace(n + 1) + "---");
        for (MdlElement mdlElement : mdlBlock) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals("Block") || !(mdlBlock2 = (MdlBlock)mdlElement).isBlockType("Outport")) continue;
            this.analyseBlock(mdlBlock2, n + 1);
            linkedList.add(mdlBlock2);
        }
        System.out.println(this.getIndentSpace(n + 1) + "---");
        for (MdlElement mdlElement : mdlBlock) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals("Block") || linkedList.contains(mdlBlock2 = (MdlBlock)mdlElement) || mdlBlock2.isBlockType("SubSystem")) continue;
            this.analyseBlock(mdlBlock2, n + 1);
            linkedList.add(mdlBlock2);
        }
        for (MdlElement mdlElement : mdlBlock) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals("Block") || linkedList.contains(mdlBlock2 = (MdlBlock)mdlElement)) continue;
            this.analyseBlock(mdlBlock2, n + 1);
        }
    }

    private void analyseBlock(MdlBlock mdlBlock, int n) {
        assert (mdlBlock.getName().equals("Block"));
        if (mdlBlock.isBlockType("SubSystem")) {
            if (mdlBlock.containsBlock("System")) {
                this.analyseSystem(mdlBlock.getBlock("System"), n);
            } else {
                this.printBlockInfo("SubSystem", mdlBlock.getAttributeValue("Name"), n);
                System.out.println(this.getIndentSpace(n + 1) + "?");
            }
        } else if (mdlBlock.hasAttribute("BlockType")) {
            String string = mdlBlock.getAttributeValue("Name");
            BlockInfoTag blockInfoTag = BlockInfoTag.VOID;
            if (!this.checkTranslatable(mdlBlock)) {
                blockInfoTag = BlockInfoTag.NONTRANSLATABLE;
            }
            this.printBlockInfo(mdlBlock.getAttributeValue("BlockType"), string, n, blockInfoTag);
        }
    }

    private void printBlockInfo(String string, String string2, int n) {
        this.printBlockInfo(string, string2, n, BlockInfoTag.VOID);
    }

    private void printBlockInfo(String string, String string2, int n, BlockInfoTag blockInfoTag) {
        String string3;
        if (string2 == null) {
            string2 = "?";
        }
        assert (blockInfoTag != null);
        switch (blockInfoTag) {
            case VOID: {
                string3 = this.getIndentSpace(n) + string + " " + string2;
                break;
            }
            case NONTRANSLATABLE: {
                string3 = this.getIndentSpace(n) + string + " " + string2 + " (non-translatable)";
                if (!USE_COLOURED_OUTPUT) break;
                string3 = PrintUtils.intoRed(string3);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        System.out.println(string3);
    }

    private boolean checkTranslatable(MdlBlock mdlBlock) {
        for (String object : DEFAULT_TRANSLATABLE_BLOCKS) {
            if (!mdlBlock.isBlockType(object)) continue;
            return true;
        }
        for (LibraryMetaFile libraryMetaFile : this.lmfs) {
            if (!libraryMetaFile.matches(mdlBlock)) continue;
            return true;
        }
        return false;
    }

    public static void useColouredOutput(boolean bl) {
        USE_COLOURED_OUTPUT = bl;
    }

    private String getIndentSpace(int n) {
        return PrintUtils.getIndentSpace(n, 2);
    }
}

