/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox;

import java.util.LinkedList;
import org.zeyda.clawcircus.Data.Simulink.MdlAttribute;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Data.Simulink.MdlElement;

public class MdlClawZAdaptor {
    private static boolean verbose_output;

    public static void invoke(MdlBlock mdlBlock) {
        MdlClawZAdaptor.discardProblematicBlocks(mdlBlock);
        MdlClawZAdaptor.populateBlockParameterDefaults(mdlBlock);
    }

    private static void discardProblematicBlocks(MdlBlock mdlBlock) {
        LinkedList<MdlBlock> linkedList = new LinkedList<MdlBlock>();
        for (MdlElement mdlElement : mdlBlock) {
            MdlBlock mdlBlock2;
            if (!mdlElement.isBlock() || !MdlClawZAdaptor.checkForProblematicSymbols(mdlBlock2 = (MdlBlock)mdlElement)) continue;
            linkedList.add(mdlBlock2);
        }
        for (MdlBlock mdlBlock3 : linkedList) {
            mdlBlock3.remove();
            MdlClawZAdaptor.printVerbose("Removed Simulink block " + mdlBlock3.getName() + " (contains $ character(s))");
        }
    }

    private static boolean checkForProblematicSymbols(MdlBlock mdlBlock) {
        return mdlBlock.serialise().contains("$");
    }

    private static void populateBlockParameterDefaults(MdlBlock mdlBlock) {
        MdlBlock mdlBlock2 = mdlBlock.getBlock("BlockParameterDefaults");
        if (mdlBlock2 == null) {
            MdlClawZAdaptor.printVerbose("BlockParameterDefaults block not present, no propagation was performed.");
            return;
        }
        MdlBlock mdlBlock3 = mdlBlock.getBlock("System");
        if (mdlBlock3 == null) {
            System.out.println("System block not present, no propagation was performed.");
            return;
        }
        for (MdlElement mdlElement : mdlBlock2) {
            MdlAttribute mdlAttribute;
            MdlBlock mdlBlock4;
            if (!mdlElement.isBlock() || !(mdlBlock4 = (MdlBlock)mdlElement).getName().equals("Block") || (mdlAttribute = mdlBlock4.getAttribute("BlockType")) == null) continue;
            String string = mdlAttribute.getValue();
            if (verbose_output) {
                MdlClawZAdaptor.printVerbose("Populating default attributes for BlockType " + string);
            }
            for (MdlElement mdlElement2 : mdlBlock4) {
                if (!mdlElement2.isAttribute() || mdlElement2 == mdlAttribute) continue;
                MdlClawZAdaptor.infuseAttribute(mdlBlock3, string, (MdlAttribute)mdlElement2);
            }
        }
    }

    private static void infuseAttribute(MdlBlock mdlBlock, String string, MdlAttribute mdlAttribute) {
        if (mdlBlock.getName().equals("Block") && mdlBlock.hasAttribute("BlockType") && mdlBlock.getAttributeValue("BlockType").equals(string) && !mdlBlock.hasAttribute(mdlAttribute.getName())) {
            mdlBlock.add((MdlAttribute)mdlAttribute.clone());
        }
        for (MdlElement mdlElement : mdlBlock) {
            if (!mdlElement.isBlock()) continue;
            MdlClawZAdaptor.infuseAttribute((MdlBlock)mdlElement, string, mdlAttribute);
        }
    }

    private static void printVerbose(String string) {
        if (verbose_output) {
            System.out.println(string);
        }
    }

    public static void enableVerboseOutput() {
        verbose_output = true;
    }

    public static void disableVerboseOutput() {
        verbose_output = false;
    }

    static {
        MdlClawZAdaptor.disableVerboseOutput();
    }
}

