/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox;

import java.util.Iterator;
import org.zeyda.clawcircus.Application.GlobalErrorHandler;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.BlockFactory;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortType;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Data.Simulink.MdlElement;
import org.zeyda.clawcircus.collections.PortList;
import org.zeyda.clawcircus.collections.impl.PortListImpl;
import org.zeyda.clawcircus.exceptions.BlockInstantiationException;
import org.zeyda.clawcircus.exceptions.MdlSemanticException;
import org.zeyda.clawcircus.utils.DiagramUtils;
import org.zeyda.clawcircus.utils.MdlUtils;
import org.zeyda.clawcircus.utils.StringUtils;

public class DiagramConstructor {
    public static SubSystem invoke(MdlBlock mdlBlock) throws MdlSemanticException {
        if (!mdlBlock.isBlock() || !mdlBlock.getName().equals("Model")) {
            throw new IllegalArgumentException("Model block expected.");
        }
        MdlBlock mdlBlock2 = mdlBlock.getBlock("System");
        if (mdlBlock2 == null) {
            throw new MdlSemanticException("System block not present.", mdlBlock);
        }
        return DiagramConstructor.createSubSystem(mdlBlock2);
    }

    public static SubSystem createSubSystem(MdlBlock mdlBlock) throws MdlSemanticException {
        Object object;
        Object object2;
        MdlBlock mdlBlock2;
        if (!mdlBlock.isBlock() || !mdlBlock.getName().equals("System")) {
            throw new IllegalArgumentException("System block expected.");
        }
        String string = MdlUtils.getStringAttribute("Name", mdlBlock);
        SubSystem subSystem = new SubSystem(string);
        for (MdlElement mdlElement : mdlBlock) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals("Block")) continue;
            mdlBlock2 = (MdlBlock)mdlElement;
            if (mdlBlock2.isBlockType("SubSystem")) {
                object2 = mdlBlock2.getBlock("System");
                if (object2 == null) {
                    throw new MdlSemanticException("System block not present.", mdlBlock2);
                }
                subSystem.add(DiagramConstructor.createSubSystem((MdlBlock)object2));
                continue;
            }
            try {
                subSystem.add(BlockFactory.create(mdlBlock2));
            }
            catch (BlockInstantiationException blockInstantiationException) {
                object = MdlUtils.getStringAttribute("BlockType", mdlBlock2);
                GlobalErrorHandler.warning("Block of type " + (String)object + " couldn't be instantiated.");
            }
        }
        for (MdlElement mdlElement : mdlBlock) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals("Line") || (object2 = DiagramConstructor.fetchSrcPort(mdlBlock2 = (MdlBlock)mdlElement, subSystem)) == null) continue;
            object = DiagramConstructor.fetchDstPorts(mdlBlock2, subSystem);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Port port = (Port)iterator.next();
                DiagramUtils.connect((Port)object2, port);
            }
        }
        return subSystem;
    }

    private static Port fetchSrcPort(MdlBlock mdlBlock, SubSystem subSystem) throws MdlSemanticException {
        assert (mdlBlock.getName().equals("Line"));
        String string = MdlUtils.getStringAttribute("SrcBlock", mdlBlock);
        int n = MdlUtils.getIntegerAttribute("SrcPort", mdlBlock);
        Block block = subSystem.find(string);
        Port port = null;
        if (block == null) {
            GlobalErrorHandler.warning("Couldn't resolve source in Line or Branch from " + StringUtils.quote(string) + ".");
            return null;
        }
        port = block.getOutputPort(n);
        return port;
    }

    private static PortList fetchDstPorts(MdlBlock mdlBlock, SubSystem subSystem) throws MdlSemanticException {
        assert (mdlBlock.getName().equals("Line") || mdlBlock.getName().equals("Branch"));
        PortListImpl portListImpl = new PortListImpl();
        if (mdlBlock.hasAttribute("DstBlock")) {
            String string = MdlUtils.getStringAttribute("DstBlock", mdlBlock);
            Object object = MdlUtils.getStringAttribute("DstPort", mdlBlock);
            Block block = subSystem.find(string);
            if (block == null) {
                GlobalErrorHandler.warning("Couldn't resolve target in Line or Branch to " + StringUtils.quote(string) + ".");
            } else {
                Port port = null;
                int n = 0;
                try {
                    n = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n == 0) {
                    if (((String)object).equals("enable")) {
                        port = block.getInputPort(PortType.ENABLE);
                    }
                    if (((String)object).equals("trigger")) {
                        port = block.getInputPort(PortType.TRIGGER);
                    }
                    if (((String)object).equals("ifaction")) {
                        port = block.getInputPort(PortType.ACTION);
                    }
                } else {
                    port = block.getInputPort(n);
                }
                if (port != null) {
                    portListImpl.add(port);
                } else {
                    System.err.println("Unsupported destination " + StringUtils.quote((String)object) + " in Line or Branch.");
                }
            }
        }
        for (Object object : mdlBlock) {
            if (!((MdlElement)object).isBlock() || !((MdlElement)object).getName().equals("Branch")) continue;
            portListImpl.addAll(DiagramConstructor.fetchDstPorts((MdlBlock)object, subSystem));
        }
        return portListImpl;
    }
}

