/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox;

import java.io.File;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.zeyda.clawcircus.IO.ClaSP.ClaSPJAXB;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockLibraryXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockTypeXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockWiringXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.ClaSPXml;
import org.zeyda.clawcircus.utils.MiscUtils;

public class ClaSPLibrary {
    public static final String BLOCK_LIBRARY_FILE = "clasp/blocklibrary.xml";
    private static ClaSPXml block_library;

    private static void load() {
        JAXBElement jAXBElement;
        try {
            jAXBElement = (JAXBElement)ClaSPJAXB.getUnmarshaller().unmarshal(new File(BLOCK_LIBRARY_FILE));
        }
        catch (JAXBException jAXBException) {
            System.out.println("Error reading ClaSP block library from clasp/blocklibrary.xml");
            System.out.println(jAXBException.toString());
            System.exit(-1);
            throw new AssertionError();
        }
        block_library = (ClaSPXml)jAXBElement.getValue();
    }

    public static void reload() {
        ClaSPLibrary.load();
    }

    public static ClaSPXml getRoot() {
        return ClaSPLibrary.getClaSP();
    }

    public static ClaSPXml getClaSP() {
        return block_library;
    }

    public static BlockTypeXml getBlockType(String string) {
        ClaSPXml claSPXml = ClaSPLibrary.getClaSP();
        BlockLibraryXml blockLibraryXml = claSPXml.getBlockLibrary();
        for (BlockTypeXml blockTypeXml : blockLibraryXml.getBlockType()) {
            if (!blockTypeXml.getName().equals(string)) continue;
            return blockTypeXml;
        }
        return null;
    }

    public static BlockWiringXml getBlockWiring(String string) {
        ClaSPXml claSPXml = ClaSPLibrary.getClaSP();
        BlockTypeXml blockTypeXml = ClaSPLibrary.getBlockType(string);
        if (blockTypeXml == null) {
            return null;
        }
        return blockTypeXml.getBlockWiring();
    }

    public static Integer parseInps(BlockTypeXml blockTypeXml) {
        String string = blockTypeXml.getBlockWiring().getInps();
        if (string == null) {
            return 0;
        }
        if ((string = string.trim().toLowerCase()).equals("varlength")) {
            return null;
        }
        assert (MiscUtils.canBeParsedAsInt(string));
        return Integer.parseInt(string);
    }

    public static Integer parseOuts(BlockTypeXml blockTypeXml) {
        String string = blockTypeXml.getBlockWiring().getOuts();
        if (string == null) {
            return 0;
        }
        if ((string = string.trim().toLowerCase()).equals("varlength")) {
            return null;
        }
        assert (MiscUtils.canBeParsedAsInt(string));
        return Integer.parseInt(string);
    }

    static {
        ClaSPLibrary.load();
        assert (block_library != null);
    }
}

