/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Parser;

import java.util.ArrayList;
import java.util.List;
import org.zeyda.clawcircus.Data.Simulink.MdlAttribute;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Parser.MdlLexer;
import org.zeyda.clawcircus.Parser.Token;
import org.zeyda.clawcircus.exceptions.ParserException;
import org.zeyda.clawcircus.utils.StringUtils;

public class MdlParser {
    protected MdlLexer lexer;

    public MdlParser(MdlLexer mdlLexer) {
        assert (mdlLexer != null);
        this.lexer = mdlLexer;
        mdlLexer.reset();
    }

    public MdlBlock parseMdl() throws ParserException {
        this.lexer.reset();
        Token token = this.lexer.current();
        if (!token.isValidName() || !token.getText().equals("Model")) {
            throw new ParserException("\"Model\" expected here", token);
        }
        return this.parseBlock();
    }

    public List<MdlBlock> parseLmf() throws ParserException {
        ArrayList<MdlBlock> arrayList = new ArrayList<MdlBlock>();
        this.lexer.reset();
        while (!this.lexer.eof()) {
            Token token = this.lexer.current();
            if (!token.isValidName() || !token.getText().equals("BlockSpecification")) {
                throw new ParserException("\"BlockSpecification\" expected here", token);
            }
            arrayList.add(this.parseBlock());
        }
        return arrayList;
    }

    protected MdlBlock parseBlock() throws ParserException {
        Token token = this.lexer.consume();
        if (!token.isValidName()) {
            throw new ParserException("valid block name expected here", token);
        }
        if (!this.lexer.consume().isLCURLY()) {
            throw new ParserException("{ expected here", this.lexer.last());
        }
        MdlBlock mdlBlock = new MdlBlock(token.toString());
        while (!this.lexer.current().isRCURLY()) {
            token = this.lexer.current();
            if (!token.isValidName()) {
                throw new ParserException("valid attribute / block name or } expected here", token);
            }
            if (this.lexer.next().isLCURLY()) {
                mdlBlock.add(this.parseBlock());
                continue;
            }
            mdlBlock.add(this.parseAttribute());
        }
        this.lexer.consume();
        return mdlBlock;
    }

    protected MdlAttribute parseAttribute() throws ParserException {
        Token token = this.lexer.consume();
        if (!token.isValidName()) {
            throw new ParserException("valid attribute name expected here", token);
        }
        Token token2 = this.lexer.consume();
        if (!token2.isValidValue()) {
            throw new ParserException("valid attribute value expected here", token2);
        }
        String string = token2.toString();
        if (token2.isQuotedText()) {
            while (this.lexer.current().isQuotedText()) {
                string = StringUtils.joinQuoted(string, this.lexer.consume().toString());
            }
        }
        return new MdlAttribute(token.toString(), string);
    }
}

