/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Parser;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.LinkedList;
import org.zeyda.clawcircus.Parser.Token;
import org.zeyda.clawcircus.Parser.TokenType;
import org.zeyda.clawcircus.utils.StringUtils;

public class MdlLexer {
    private StreamTokenizer tokeniser;
    private Token[] tokens;
    private int index;

    public MdlLexer(String string) {
        this.tokeniser = new StreamTokenizer(new StringReader(string));
        this.tokens = new Token[0];
        this.configureSyntax();
        try {
            this.generateTokens();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            System.exit(-1);
        }
        this.reset();
    }

    private void configureSyntax() {
        this.tokeniser.resetSyntax();
        this.tokeniser.wordChars(0, 255);
        this.tokeniser.quoteChar(34);
        this.tokeniser.quoteChar(91);
        this.tokeniser.ordinaryChar(123);
        this.tokeniser.ordinaryChar(125);
        this.tokeniser.whitespaceChars(32, 32);
        this.tokeniser.whitespaceChars(9, 9);
        this.tokeniser.whitespaceChars(10, 10);
        this.tokeniser.whitespaceChars(13, 13);
        this.tokeniser.eolIsSignificant(false);
        this.tokeniser.slashSlashComments(false);
        this.tokeniser.slashStarComments(false);
    }

    private void generateTokens() throws IOException {
        Token token;
        LinkedList<Token> linkedList = new LinkedList<Token>();
        do {
            this.tokeniser.nextToken();
            int n = this.tokeniser.lineno();
            switch (this.tokeniser.ttype) {
                case -3: {
                    assert (this.tokeniser.sval != null);
                    token = new Token(TokenType.TEXT, this.tokeniser.sval, n);
                    break;
                }
                case 34: {
                    assert (this.tokeniser.sval != null);
                    this.tokeniser.sval = StringUtils.quote(this.tokeniser.sval);
                    token = new Token(TokenType.QUOTED_TEXT, this.tokeniser.sval, n);
                    break;
                }
                case 91: {
                    assert (this.tokeniser.sval != null);
                    token = new Token(TokenType.TEXT, "[" + this.tokeniser.sval, n);
                    break;
                }
                case 123: {
                    token = new Token(TokenType.LCURLY, n);
                    break;
                }
                case 125: {
                    token = new Token(TokenType.RCURLY, n);
                    break;
                }
                case -1: {
                    token = new Token(TokenType.EOF, n);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            linkedList.add(token);
        } while (!token.isEOF());
        this.tokens = linkedList.toArray(this.tokens);
    }

    public void dumpTokens() {
        for (Token token : this.tokens) {
            System.out.println("[" + token + "]");
        }
    }

    public void reset() {
        this.index = 0;
    }

    public Token LL(int n) {
        assert (this.index + n >= 0);
        if (this.index + n < this.tokens.length) {
            return this.tokens[this.index + n];
        }
        if (this.tokens.length != 0 && this.tokens[this.tokens.length - 1].getType() == TokenType.EOF) {
            return this.tokens[this.tokens.length - 1];
        }
        return Token.EOF_TOKEN;
    }

    public Token consume() {
        Token token = this.current();
        if (this.index < this.tokens.length) {
            ++this.index;
        }
        return token;
    }

    public boolean eof() {
        return this.current().isEOF();
    }

    public Token next() {
        return this.LL(1);
    }

    public Token last() {
        return this.LL(-1);
    }

    public Token current() {
        return this.LL(0);
    }
}

