/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Simulink;

import org.zeyda.clawcircus.Data.Simulink.MdlAttribute;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

public abstract class MdlElement
implements Cloneable {
    private String name;
    private MdlBlock parent;

    protected MdlElement(String string) {
        this.setName(string);
        this.parent = null;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) {
        assert (string != null);
        this.name = string.trim();
        this.name = string;
    }

    public MdlBlock getParent() {
        return this.parent;
    }

    public void setParent(MdlBlock mdlBlock) {
        assert (!this.hasParent() || mdlBlock == null);
        this.parent = mdlBlock;
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public void remove() {
        if (this.hasParent()) {
            this.getParent().remove(this);
        }
        assert (!this.hasParent());
    }

    public boolean isAttribute() {
        return this instanceof MdlAttribute;
    }

    public boolean isBlock() {
        return this instanceof MdlBlock;
    }

    public int getLevel() {
        int n = 0;
        MdlElement mdlElement = this;
        while (mdlElement.hasParent()) {
            ++n;
            mdlElement = mdlElement.getParent();
        }
        return n;
    }

    protected Object clone() {
        MdlElement mdlElement;
        try {
            mdlElement = (MdlElement)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
        mdlElement.setParent(null);
        return mdlElement;
    }

    public abstract String serialise();
}

