/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Diagram;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.BlockWiringType;
import org.zeyda.clawcircus.Data.ClaSP.Enabled;
import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.BlockFactory;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortBlock;
import org.zeyda.clawcircus.Data.Diagram.PortDir;
import org.zeyda.clawcircus.Data.Diagram.PortType;
import org.zeyda.clawcircus.Data.Diagram.ResolveMethod;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Toolbox.TranslationStrategy;
import org.zeyda.clawcircus.collections.BlockList;
import org.zeyda.clawcircus.collections.FlowSet;
import org.zeyda.clawcircus.collections.LinkSet;
import org.zeyda.clawcircus.collections.SignalSet;
import org.zeyda.clawcircus.collections.impl.BlockListImpl;
import org.zeyda.clawcircus.collections.impl.FlowSetImpl;
import org.zeyda.clawcircus.collections.impl.LinkSetImpl;
import org.zeyda.clawcircus.collections.impl.SignalListImpl;
import org.zeyda.clawcircus.collections.impl.SignalSetImpl;
import org.zeyda.clawcircus.exceptions.BlockInstantiationException;
import org.zeyda.clawcircus.exceptions.MdlSemanticException;
import org.zeyda.clawcircus.utils.ClaSPUtils;

public class SubSystem
extends Block
implements Iterable<Block> {
    protected final BlockList blocks = new BlockListImpl();
    private BlockWiring block_wiring_inner_cache = null;

    public SubSystem() {
        super(0, 0);
        this.setProperty("translatable", true);
        this.setProperty("state", false);
    }

    public SubSystem(String string) {
        this();
        this.setName(string);
    }

    @Override
    public void initialise() throws MdlSemanticException {
        super.initialise();
        if (this.hasAnnotation(MdlBlock.class)) {
            MdlBlock mdlBlock = this.getAnnotation(MdlBlock.class);
        }
    }

    public BlockList getBlocks() {
        return this.blocks;
    }

    public void add(Block block) {
        this.blocks.add(block);
        block.setParent(this);
        if (block.isPort()) {
            this.updateLinks(block);
        }
    }

    public void addAll(BlockList blockList) {
        for (Block block : blockList) {
            this.add(block);
        }
    }

    public Block find(String string) {
        for (Block block : this.blocks) {
            if (!block.getName().equals(string)) continue;
            return block;
        }
        return null;
    }

    protected void updateLinks(Block block) {
        int n;
        if (block.isInport() && (n = ((PortBlock)block).getPortNum()) > this.getInputPortsNum()) {
            this.updateIncomingLinks(n);
        }
        if (block.isOutport() && (n = ((PortBlock)block).getPortNum()) > this.getOutputPortsNum()) {
            this.updateOutgoingLinks(n);
        }
    }

    public void updateLinks() {
        int n = 0;
        int n2 = 0;
        for (Block block : this.blocks) {
            int n3;
            if (block.isInport()) {
                n3 = ((PortBlock)block).getPortNum();
                n = Math.max(n3, n);
            }
            if (!block.isOutport()) continue;
            n3 = ((PortBlock)block).getPortNum();
            n2 = Math.max(n3, n2);
        }
        this.updateLinks(n, n2);
    }

    public Port resolveIntoPort(Block block) {
        assert (this.blocks.contains(block));
        Port port = null;
        if (block.isInport()) {
            port = new Port((Block)this, ((PortBlock)block).getPortNum(), PortDir.INPUT);
        }
        if (block.isOutport()) {
            port = new Port((Block)this, ((PortBlock)block).getPortNum(), PortDir.OUTPUT);
        }
        if (block.isEnablePort()) {
            port = new Port((Block)this, PortType.ENABLE, PortDir.INPUT);
        }
        if (block.isTriggerPort()) {
            port = new Port((Block)this, PortType.TRIGGER, PortDir.INPUT);
        }
        if (block.isActionPort()) {
            port = new Port((Block)this, PortType.ACTION, PortDir.INPUT);
        }
        if (port != null) assert (port.isValid());
        return port;
    }

    public PortBlock resolveIntoBlock(Port port) {
        assert (port.getBlock() == this);
        for (Block block : this.blocks) {
            if (!block.isPort()) continue;
            PortBlock portBlock = (PortBlock)block;
            if (port.isStandard()) {
                if (block.isInport() && port.isInput() && portBlock.getPortNum() == port.getPortNum()) {
                    return portBlock;
                }
                if (!block.isOutport() || !port.isOutput() || portBlock.getPortNum() != port.getPortNum()) continue;
                return portBlock;
            }
            assert (port.isSpecial());
            if (!port.isInput()) continue;
            if (block.isEnablePort() && port.isEnable()) {
                return portBlock;
            }
            if (block.isTriggerPort() && port.isTrigger()) {
                return portBlock;
            }
            if (!block.isActionPort() || !port.isAction()) continue;
            return portBlock;
        }
        return null;
    }

    public LinkSet getExternalLinks() {
        return super.getAllLinks();
    }

    public LinkSet getInternalLinks() {
        LinkSetImpl linkSetImpl = new LinkSetImpl();
        for (Block block : this.getChildren()) {
            if (!(block instanceof SubSystem)) continue;
            linkSetImpl.addAll(((SubSystem)block).getExternalLinks());
        }
        return linkSetImpl;
    }

    public BlockWiring getBlockWiring(BlockWiringType blockWiringType) {
        if (blockWiringType == BlockWiringType.OUTER) {
            return this.getBlockWiring();
        }
        assert (blockWiringType == BlockWiringType.INNER);
        if (this.block_wiring_inner_cache == null) {
            this.block_wiring_inner_cache = this.calcBlockWiring(BlockWiringType.INNER);
        }
        assert (this.block_wiring_inner_cache != null);
        return this.block_wiring_inner_cache;
    }

    @Override
    public BlockWiring calcBlockWiring() {
        return this.calcBlockWiring(BlockWiringType.OUTER);
    }

    protected BlockWiring calcBlockWiring(BlockWiringType blockWiringType) {
        Object object3;
        Object object22;
        ResolveMethod resolveMethod;
        if (blockWiringType == BlockWiringType.INNER) {
            resolveMethod = ResolveMethod.INTERNAL;
        } else {
            assert (blockWiringType == BlockWiringType.OUTER);
            resolveMethod = ResolveMethod.EXTERNAL;
        }
        SignalListImpl signalListImpl = new SignalListImpl();
        for (Object object22 : this.getInputPorts()) {
            signalListImpl.add(ClaSPUtils.getSignalFromPort((Port)object22, resolveMethod));
        }
        SignalListImpl signalListImpl2 = new SignalListImpl();
        for (Object object3 : this.getOutputPorts()) {
            signalListImpl2.add(ClaSPUtils.getSignalFromPort((Port)object3, resolveMethod));
        }
        object22 = new FlowSetImpl();
        object3 = signalListImpl2.iterator();
        while (object3.hasNext()) {
            Signal signal = (Signal)object3.next();
            if (signal == null) continue;
            SignalSetImpl signalSetImpl = new SignalSetImpl();
            signalSetImpl.add(signal);
            if (blockWiringType != BlockWiringType.INNER) {
                signal = signal.unlift();
            }
            if (signal == null) continue;
            SignalSet signalSet = signal.traceBackToInputs();
            if (blockWiringType != BlockWiringType.INNER) {
                signalSet = signalSet.lift();
            }
            object22.add(new Flow(Enabled.ALWAYS, false, signalSet, signalSetImpl));
        }
        BlockWiring blockWiring = new BlockWiring(signalListImpl, signalListImpl2, (FlowSet)object22);
        blockWiring.normalise();
        return blockWiring;
    }

    public BlockWiring getFlatBlockWiring(BlockWiringType blockWiringType) {
        Object object3;
        Object object22;
        ResolveMethod resolveMethod;
        if (blockWiringType == BlockWiringType.INNER) {
            resolveMethod = ResolveMethod.INTERNAL;
        } else {
            assert (blockWiringType == BlockWiringType.OUTER);
            resolveMethod = ResolveMethod.EXTERNAL;
        }
        SignalListImpl signalListImpl = new SignalListImpl();
        for (Object object22 : this.getInputPorts()) {
            signalListImpl.add(ClaSPUtils.getSignalFromPort((Port)object22, resolveMethod));
        }
        SignalListImpl signalListImpl2 = new SignalListImpl();
        for (Object object3 : this.getOutputPorts()) {
            signalListImpl2.add(ClaSPUtils.getSignalFromPort((Port)object3, resolveMethod));
        }
        object22 = new FlowSetImpl();
        object3 = new SignalSetImpl(signalListImpl);
        SignalSetImpl signalSetImpl = new SignalSetImpl(signalListImpl2);
        object22.add(new Flow(Enabled.ALWAYS, false, (SignalSet)object3, signalSetImpl));
        return new BlockWiring(signalListImpl, signalListImpl2, (FlowSet)object22);
    }

    @Override
    public void clearAllBlockWiring() {
        super.clearAllBlockWiring();
        this.block_wiring_inner_cache = null;
    }

    public void printDetails() {
        System.out.println("SubSystem: " + this.getPath());
        System.out.println("---");
        System.out.println("[Blocks]");
        for (Object object : this.blocks) {
            System.out.println("  " + object);
        }
        System.out.println("---");
        System.out.println("[Links]");
        for (Object object : this.getInternalLinks()) {
            System.out.println("  " + object);
        }
    }

    public void printAllDetails() {
        this.printDetails();
        for (Block block : this.blocks) {
            if (!block.isSubSystem()) continue;
            System.out.println();
            ((SubSystem)block).printAllDetails();
        }
    }

    @Override
    public BlockList getChildren() {
        return this.getBlocks();
    }

    public static SubSystem create() {
        try {
            return (SubSystem)BlockFactory.create("SubSystem");
        }
        catch (BlockInstantiationException blockInstantiationException) {
            throw new AssertionError((Object)blockInstantiationException);
        }
    }

    public TranslationStrategy getTranslationStrategy() {
        return this.getAnnotation(TranslationStrategy.class);
    }

    public void setTranslationStrategy(TranslationStrategy translationStrategy) {
        this.setAnnotation((Object)translationStrategy);
        this.notifyUI();
    }

    public final boolean isCentralised() {
        return this.getTranslationStrategy() == TranslationStrategy.CENTRALISED;
    }

    public final boolean isParallel() {
        return this.getTranslationStrategy() == TranslationStrategy.PARALLEL;
    }
}

