/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Diagram;

import java.util.LinkedList;
import java.util.List;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.BlockUtil;
import org.zeyda.clawcircus.Data.Diagram.GenericBlock;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockTypeXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockWiringXml;
import org.zeyda.clawcircus.Toolbox.ClaSPLibrary;
import org.zeyda.clawcircus.exceptions.BlockInstantiationException;
import org.zeyda.clawcircus.exceptions.MdlSemanticException;
import org.zeyda.clawcircus.utils.MdlUtils;

public class BlockFactory {
    private static List<String> class_locs = new LinkedList<String>();

    public static void register(String string) {
        class_locs.add(0, string);
    }

    public static void defaults() {
        class_locs.clear();
        BlockFactory.register("org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen");
        BlockFactory.register("org.zeyda.clawcircus.Data.Diagram.BlockTypes.custom");
    }

    public static Block create(MdlBlock mdlBlock) throws BlockInstantiationException {
        String string;
        assert (mdlBlock != null);
        try {
            string = MdlUtils.getStringAttribute("BlockType", mdlBlock);
        }
        catch (MdlSemanticException mdlSemanticException) {
            throw new BlockInstantiationException(mdlSemanticException);
        }
        Block block = BlockFactory.create(string);
        assert (block != null);
        block.setAnnotation(mdlBlock);
        try {
            block.initialise();
        }
        catch (MdlSemanticException mdlSemanticException) {
            throw new BlockInstantiationException(mdlSemanticException);
        }
        return block;
    }

    public static Block create(String string) throws BlockInstantiationException {
        Block block = null;
        String string2 = BlockUtil.convBlockTypeToClass(string);
        Class<?> clazz = null;
        for (String string3 : class_locs) {
            try {
                clazz = null;
                clazz = Class.forName(string3 + "." + string2);
                if (!Block.class.isAssignableFrom(clazz)) continue;
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        if (clazz != null) {
            try {
                block = (Block)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new BlockInstantiationException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new BlockInstantiationException(illegalAccessException);
            }
        } else {
            block = BlockFactory.createGenericBlock(string);
        }
        if (block == null) {
            throw new BlockInstantiationException("No class or entry in ClaSP library for " + string + " block.");
        }
        return block;
    }

    private static Block createGenericBlock(String string) {
        BlockTypeXml blockTypeXml = ClaSPLibrary.getBlockType(string);
        GenericBlock genericBlock = null;
        if (blockTypeXml != null) {
            assert (string.equals(blockTypeXml.getName()));
            BlockWiringXml blockWiringXml = blockTypeXml.getBlockWiring();
            Integer n = ClaSPLibrary.parseInps(blockTypeXml);
            Integer n2 = ClaSPLibrary.parseOuts(blockTypeXml);
            boolean bl = blockTypeXml.isTranslatable();
            boolean bl2 = blockTypeXml.isState();
            genericBlock = new GenericBlock(string, n, n2, bl, bl2);
        }
        return genericBlock;
    }

    static {
        BlockFactory.defaults();
    }
}

