/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.ClawZ;

import java.util.Iterator;
import java.util.List;
import org.zeyda.clawcircus.Data.ClawZ.PatternMatcher;
import org.zeyda.clawcircus.Data.Simulink.MdlAttribute;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Data.Simulink.MdlElement;

public class LibraryMetaFile {
    protected List<MdlBlock> block_spec_list;

    public LibraryMetaFile(List<MdlBlock> list) {
        this.block_spec_list = list;
    }

    public MdlBlock findMatch(MdlBlock mdlBlock) {
        MdlBlock mdlBlock2 = null;
        for (MdlBlock mdlBlock3 : this.block_spec_list) {
            if (!LibraryMetaFile.matches(mdlBlock, mdlBlock3)) continue;
            mdlBlock2 = mdlBlock3;
        }
        return mdlBlock2;
    }

    public boolean matches(MdlBlock mdlBlock) {
        return this.findMatch(mdlBlock) != null;
    }

    protected static boolean matches(MdlBlock mdlBlock, MdlBlock mdlBlock2) {
        Object object;
        if (mdlBlock2.hasAttribute("BlockPath")) {
            object = mdlBlock2.getAttributeValue("BlockPath");
            if (!PatternMatcher.match(mdlBlock.getBlockPath(), (String)object)) {
                return false;
            }
        }
        if (!mdlBlock2.containsBlock("SelectionParameters")) {
            return false;
        }
        object = mdlBlock2.getBlock("SelectionParameters");
        Iterator<MdlElement> iterator = ((MdlBlock)object).iterator();
        while (iterator.hasNext()) {
            MdlAttribute mdlAttribute;
            MdlElement mdlElement = iterator.next();
            if (!mdlElement.isAttribute() || mdlBlock.hasAttribute((mdlAttribute = (MdlAttribute)mdlElement).getName()) && mdlBlock.getAttributeValue(mdlAttribute.getName()).equals(mdlAttribute.getValue())) continue;
            return false;
        }
        return true;
    }

    public String serialise() {
        StringBuilder stringBuilder = new StringBuilder();
        for (MdlBlock mdlBlock : this.block_spec_list) {
            stringBuilder.append(((MdlElement)mdlBlock).serialise() + "\n");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.serialise();
    }
}

