/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.ClaSP;

import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Link;
import org.zeyda.clawcircus.Data.Diagram.ResolveMethod;
import org.zeyda.clawcircus.collections.SignalSet;
import org.zeyda.clawcircus.collections.impl.SignalSetImpl;
import org.zeyda.clawcircus.utils.ClaSPUtils;

public class Signal {
    public static final String SIGNAL_SUFFIX = "_out";
    protected final Link wire;

    public Signal(Link link) {
        assert (link != null);
        this.wire = link;
    }

    public Link getLink() {
        return this.wire;
    }

    public String getName() {
        assert (this.wire.isSrcConnected());
        Block block = this.wire.getSrcBlock();
        String string = block.getPath().getClawZName();
        if (!block.isInport()) {
            string = string + SIGNAL_SUFFIX;
        }
        if (block.getOutputPortsNum() > 1) {
            string = string + this.wire.getSrcPort().getPortNum();
        }
        return string;
    }

    public Signal lift() {
        if (this.wire.isSrcConnected()) {
            Link link;
            Block block = this.wire.getSrcBlock();
            assert (block.isPort());
            if (block.hasParent() && (link = block.resolveIntoPort().getLink()) != null) {
                return link.getSignal();
            }
        }
        return null;
    }

    public Signal unlift() {
        if (this.wire.isSrcConnected()) {
            assert (this.wire.getSrcBlock().isSubSystem());
            return ClaSPUtils.getSignalFromPort(this.wire.getSrcPort(), ResolveMethod.INTERNAL);
        }
        return null;
    }

    public SignalSet traceBackToInputs() {
        SignalSetImpl signalSetImpl = new SignalSetImpl();
        if (this.wire.isSrcConnected()) {
            if (this.connectsInport()) {
                signalSetImpl.add(this);
            } else {
                Block block = this.wire.getSrcBlock();
                BlockWiring blockWiring = block.getBlockWiring();
                Flow flow = blockWiring.getFlow(this);
                if (flow == null) {
                    assert (false);
                } else {
                    for (Signal signal : flow.getRInps()) {
                        signalSetImpl.addAll(signal.traceBackToInputs());
                    }
                }
            }
        }
        return signalSetImpl;
    }

    public boolean connectsInport() {
        return this.wire.isSrcConnected() && this.wire.getSrcBlock().isInport();
    }

    public boolean equals(Object object) {
        if (object instanceof Signal) {
            return this.wire.equals(((Signal)object).wire);
        }
        return false;
    }

    public int hashCode() {
        return this.wire.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

