/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.ClaSP;

import org.zeyda.clawcircus.Data.ClaSP.Enabled;
import org.zeyda.clawcircus.collections.SignalSet;

public class Flow {
    protected final Enabled enabled;
    protected final boolean ordered;
    protected final SignalSet rinps;
    protected final SignalSet pouts;

    public Flow(Enabled enabled, boolean bl, SignalSet signalSet, SignalSet signalSet2) {
        assert (enabled != null);
        assert (signalSet != null);
        assert (signalSet2 != null);
        this.enabled = enabled;
        this.ordered = bl;
        this.rinps = signalSet;
        this.pouts = signalSet2;
    }

    public Flow(SignalSet signalSet, SignalSet signalSet2) {
        this(Enabled.ALWAYS, false, signalSet, signalSet2);
    }

    public Enabled getEnabled() {
        return this.enabled;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public SignalSet getRInps() {
        return this.rinps;
    }

    public SignalSet getPOuts() {
        return this.pouts;
    }

    public Flow lift() {
        return new Flow(this.enabled.lift(), this.ordered, this.rinps.lift(), this.pouts.lift());
    }

    public boolean equals(Object object) {
        if (object instanceof Flow) {
            return this.enabled.equals(((Flow)object).enabled) && this.ordered == ((Flow)object).ordered && this.rinps.equals(((Flow)object).rinps) && this.pouts.equals(((Flow)object).pouts);
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.enabled.hashCode() ^ Boolean.valueOf(this.ordered).hashCode() ^ this.rinps.hashCode() ^ this.pouts.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append("enabled |-> " + this.enabled + ", ");
        stringBuilder.append("ordered |-> " + this.ordered + ", ");
        stringBuilder.append("rinps |-> " + this.rinps + ", ");
        stringBuilder.append("pouts |-> " + this.pouts);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

