/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.ClaSP;

import java.util.Iterator;
import org.zeyda.clawcircus.Application.GlobalErrorHandler;
import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.collections.FlowSet;
import org.zeyda.clawcircus.collections.SignalList;
import org.zeyda.clawcircus.collections.SignalSet;
import org.zeyda.clawcircus.collections.impl.FlowSetImpl;
import org.zeyda.clawcircus.collections.impl.SignalSetImpl;
import org.zeyda.clawcircus.misc.AnnotationInterface;

public class BlockWiring
implements AnnotationInterface<BlockWiring> {
    protected final SignalList inps;
    protected final SignalList outs;
    protected FlowSet flows;

    public BlockWiring(SignalList signalList, SignalList signalList2, FlowSet flowSet) {
        assert (signalList != null);
        assert (signalList2 != null);
        assert (flowSet != null);
        this.inps = signalList;
        this.outs = signalList2;
        this.flows = flowSet;
    }

    public SignalList getInps() {
        return this.inps;
    }

    public SignalList getOuts() {
        return this.outs;
    }

    public FlowSet getFlows() {
        return this.flows;
    }

    public SignalSet getInterface() {
        SignalSetImpl signalSetImpl = new SignalSetImpl();
        for (Signal signal : this.inps) {
            signalSetImpl.addIfNotNull(signal);
        }
        for (Signal signal : this.outs) {
            signalSetImpl.addIfNotNull(signal);
        }
        return signalSetImpl;
    }

    public Flow getFlow(Signal signal) {
        assert (this.outs.contains(signal));
        for (Flow flow : this.flows) {
            if (!flow.getPOuts().contains(signal)) continue;
            return flow;
        }
        GlobalErrorHandler.warning("Couldn't obtain rinps for output signal " + signal + "; flow sets seems to be incomplete.");
        return null;
    }

    public void normalise() {
        this.minimise();
    }

    public void minimise() {
        FlowSetImpl flowSetImpl = new FlowSetImpl();
        while (!this.flows.isEmpty()) {
            Flow flow = (Flow)this.flows.select();
            this.flows.remove(flow);
            Iterator iterator = this.flows.iterator();
            while (iterator.hasNext()) {
                Flow flow2 = (Flow)iterator.next();
                if (!flow2.getRInps().equals(flow.getRInps()) || !flow2.getEnabled().equals(flow.getEnabled()) || flow2.isOrdered() != flow.isOrdered()) continue;
                flow.getPOuts().addAll(flow2.getPOuts());
                iterator.remove();
            }
            flowSetImpl.add(flow);
        }
        this.flows = flowSetImpl;
    }

    public void maximise() {
        FlowSetImpl flowSetImpl = new FlowSetImpl();
        for (Flow flow : this.flows) {
            for (Signal signal : flow.getPOuts()) {
                SignalSetImpl signalSetImpl = new SignalSetImpl();
                signalSetImpl.add(signal);
                flowSetImpl.add(new Flow(flow.getEnabled(), flow.isOrdered(), flow.getRInps(), signalSetImpl));
            }
        }
        this.flows = flowSetImpl;
    }

    public BlockWiring lift() {
        return new BlockWiring(this.inps.lift(), this.outs.lift(), this.flows.lift());
    }

    @Override
    public Class<BlockWiring> getAnnotationKey() {
        return BlockWiring.class;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[BlockWiring]\n");
        stringBuilder.append(" inps = " + this.inps.toString() + "\n");
        stringBuilder.append(" outs = " + this.outs.toString() + "\n");
        stringBuilder.append(" flows = " + this.flows.toString() + "\n");
        return stringBuilder.toString();
    }
}

