/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Data.Simulink.MdlElement;
import org.zeyda.clawcircus.Toolbox.MdlClawZAdaptor;
import org.zeyda.clawcircus.utils.FileUtils;
import org.zeyda.clawcircus.utils.ParserUtils;

class MdlMergeApp {
    MdlMergeApp() {
    }

    private static void welcome() {
        System.out.println("Simulink Model Merger 2007 (c) by Michael Vernon.");
        System.out.println("--");
    }

    private static void usage() {
        System.out.println("Usage: merge <source file>.mdl <injection file>.mdl <target file>.mdl");
        System.out.println("-> Note that the target file, if existent, will be silently overwritten.");
        System.exit(-1);
    }

    private static void addExtAtts(MdlBlock mdlBlock, MdlBlock mdlBlock2) {
        MdlElement mdlElement;
        System.out.println("Scanning " + mdlBlock.getAttribute("Name"));
        for (MdlElement mdlElement2 : mdlBlock) {
            if (!mdlElement2.isBlock() || (mdlElement = MdlMergeApp.getExtBlock((MdlBlock)mdlElement2, mdlBlock2)) == null) continue;
            MdlMergeApp.addExtAtts((MdlBlock)mdlElement2, (MdlBlock)mdlElement);
        }
        for (MdlElement mdlElement2 : mdlBlock2) {
            if (mdlElement2.isBlock() || mdlBlock.getAttribute(mdlElement2.getName()) != null) continue;
            System.out.println("Adding " + mdlElement2.getName());
            mdlElement = mdlElement2;
            mdlElement.setParent(null);
            mdlBlock.add(mdlElement);
        }
    }

    private static MdlBlock getExtBlock(MdlBlock mdlBlock, MdlBlock mdlBlock2) {
        int n = 0;
        MdlBlock mdlBlock3 = null;
        for (MdlElement mdlElement : mdlBlock2) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals(mdlBlock.getName())) continue;
            MdlBlock mdlBlock4 = (MdlBlock)mdlElement;
            if (mdlBlock.getAttribute("Name") == null || !mdlBlock4.getAttributeValue("Name").equals(mdlBlock.getAttributeValue("Name"))) continue;
            mdlBlock3 = mdlBlock4;
            ++n;
        }
        if (n > 1) {
            System.out.println("ERROR extension file duplicates block names!");
            System.exit(-1);
        }
        return mdlBlock3;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            MdlMergeApp.usage();
        }
        MdlMergeApp.welcome();
        System.out.println("Merging Simulink files: " + stringArray[0] + " and " + stringArray[1]);
        MdlBlock mdlBlock = FileUtils.readMdl(stringArray[1]);
        System.out.println("Reading from source model: " + stringArray[0]);
        String string = FileUtils.readTextFile(stringArray[0]);
        System.out.println("Parsing source model..");
        MdlBlock mdlBlock2 = ParserUtils.parseMdl(string);
        System.out.println("Merging Simulink files: " + stringArray[0] + " and " + stringArray[1]);
        MdlMergeApp.addExtAtts(mdlBlock2, mdlBlock);
        System.out.println("Adapting resulting model for ClawZ.");
        MdlClawZAdaptor.disableVerboseOutput();
        MdlClawZAdaptor.invoke(mdlBlock2);
        FileUtils.writeMdl(stringArray[2], mdlBlock2);
    }
}

