/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Application;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.czt.session.CommandException;
import net.sourceforge.czt.session.Key;
import net.sourceforge.czt.session.SectionManager;
import net.sourceforge.czt.session.Source;
import net.sourceforge.czt.session.StringSource;
import net.sourceforge.czt.z.ast.Spec;
import org.zeyda.clawcircus.Application.GlobalErrorHandler;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.IO.RedirectThread;
import org.zeyda.clawcircus.Toolbox.CircusTranslator;
import org.zeyda.clawcircus.Toolbox.DiagramConstructor;
import org.zeyda.clawcircus.Toolbox.MdlClawZAdaptor;
import org.zeyda.clawcircus.Toolbox.TranslationStrategy;
import org.zeyda.clawcircus.UI.JBlockTree;
import org.zeyda.clawcircus.exceptions.MdlSemanticException;
import org.zeyda.clawcircus.resources.Resources;
import org.zeyda.clawcircus.utils.AppUtils;
import org.zeyda.clawcircus.utils.FileUtils;

class CircusTranslatorApp {
    public static final File tmp_dir = new File("tmp");
    private static SubSystem system;
    private static JBlockTree block_tree;

    CircusTranslatorApp() {
    }

    private static void welcome() {
        AppUtils.makeWelcome("Circus Translator");
    }

    private static void usage() {
        System.out.println("Usage: circtrans <file>.mdl");
        System.exit(-1);
    }

    private static void loadMdl(String string) throws MdlSemanticException {
        MdlBlock mdlBlock = FileUtils.readMdl(string);
        MdlClawZAdaptor.invoke(mdlBlock);
        system = DiagramConstructor.invoke(mdlBlock);
    }

    private static void initUI() {
        JFrame jFrame = new JFrame("Circus Producer");
        jFrame.setDefaultCloseOperation(3);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new TitledBorder("Options"));
        JCheckBox jCheckBox = new JCheckBox("Enable Simplification");
        jCheckBox.setSelected(CircusTranslator.getSimplify());
        jCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CircusTranslator.setSimplify(((JCheckBox)changeEvent.getSource()).isSelected());
            }
        });
        jPanel.add(jCheckBox);
        jFrame.getContentPane().add((Component)jPanel, "North");
        block_tree = new JBlockTree(system);
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Translation Menu");
        jMenuItem.setEnabled(false);
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add("Show LaTeX").addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircusTranslatorApp.doShowLatex();
            }
        });
        jPopupMenu.add("Show DVI").addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircusTranslatorApp.doShowDVI();
            }
        });
        jPopupMenu.addSeparator();
        jPopupMenu.add("Expand All").addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircusTranslatorApp.doExpandAll();
            }
        });
        jPopupMenu.add("Collapse All").addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CircusTranslatorApp.doCollapseAll();
            }
        });
        block_tree.setComponentPopupMenu(jPopupMenu);
        block_tree.setSelectionPath(system.getTreePath());
        jFrame.getContentPane().add((Component)new JScrollPane(block_tree), "Center");
        jFrame.setSize(520, 600);
        jFrame.setVisible(true);
        block_tree.requestFocus();
    }

    private static void initSemantics() {
        CircusTranslatorApp.initSemantics(system);
    }

    private static void initSemantics(SubSystem subSystem) {
        if (subSystem.isRoot()) {
            subSystem.setTranslationStrategy(TranslationStrategy.PARALLEL);
        } else {
            subSystem.setTranslationStrategy(TranslationStrategy.CENTRALISED);
        }
        for (Block block : subSystem.getChildren()) {
            if (!block.isSubSystem()) continue;
            CircusTranslatorApp.initSemantics((SubSystem)block);
        }
    }

    private static void setTranslationStrategy(SubSystem subSystem, TranslationStrategy translationStrategy) {
        subSystem.setTranslationStrategy(translationStrategy);
        for (Block block : subSystem.getChildren()) {
            if (!block.isSubSystem()) continue;
            CircusTranslatorApp.setTranslationStrategy((SubSystem)block, translationStrategy);
        }
    }

    private static int invokeLatex(String string) {
        Process process = null;
        try {
            String[] stringArray = new String[]{"latex", "-halt-on-error", string};
            String[] stringArray2 = new String[]{"TEXINPUTS=../latex/style:", "PATH=" + System.getenv("PATH")};
            process = Runtime.getRuntime().exec(stringArray, stringArray2, tmp_dir);
            RedirectThread redirectThread = RedirectThread.create(process.getInputStream());
            RedirectThread redirectThread2 = RedirectThread.create(process.getErrorStream());
            process.waitFor();
            if (process.exitValue() != 0) {
                redirectThread2.flush();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            System.exit(-1);
        }
        return process.exitValue();
    }

    private static void doShowLatex() {
        try {
            File file = File.createTempFile("trans", ".tex", tmp_dir);
            String string = file.getPath();
            if (CircusTranslatorApp.translate(string)) {
                String[] stringArray = new String[]{"nedit", string};
                Runtime.getRuntime().exec(stringArray);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.exit(-1);
        }
    }

    private static void doShowDVI() {
        try {
            File file = File.createTempFile("trans", ".tex", tmp_dir);
            String string = file.getPath();
            if (CircusTranslatorApp.translate(string) && CircusTranslatorApp.invokeLatex(file.getName()) == 0) {
                String string2 = string.substring(0, string.length() - 4) + ".dvi";
                String[] stringArray = new String[]{"xdvi", "-s", "5", string2};
                Runtime.getRuntime().exec(stringArray);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.exit(-1);
        }
    }

    private static void doExpandAll() {
        if (!block_tree.isSelectionEmpty()) {
            CircusTranslatorApp.expandAll(block_tree.getSelectedBlock());
        }
    }

    private static void doCollapseAll() {
        if (!block_tree.isSelectionEmpty()) {
            CircusTranslatorApp.collapseAll(block_tree.getSelectedBlock());
        }
    }

    private static void expandAll(Block block) {
        block_tree.expandPath(block.getTreePath());
        for (Block block2 : block.getChildren()) {
            CircusTranslatorApp.expandAll(block2);
        }
    }

    private static void collapseAll(Block block) {
        for (Block block2 : block.getChildren()) {
            CircusTranslatorApp.collapseAll(block2);
        }
        block_tree.collapsePath(block.getTreePath());
    }

    private static boolean translate(String string) {
        Block block;
        if (!block_tree.isSelectionEmpty() && (block = block_tree.getSelectedBlock()).getProperty("translatable", Boolean.class).booleanValue()) {
            String string2 = CircusTranslator.translateAll(block);
            FileUtils.writeTextFile(string, string2);
            return true;
        }
        return false;
    }

    private static void parse(String string) throws CommandException {
        SectionManager sectionManager = Resources.createSectionManager();
        StringSource stringSource = new StringSource(string);
        sectionManager.put(new Key(stringSource.getName(), Source.class), (Object)stringSource);
        Spec spec = (Spec)sectionManager.get(new Key(stringSource.getName(), Spec.class));
    }

    private static void removePrefixFromSystemName(String string) {
        if (system.getName().startsWith(string)) {
            system.setName(system.getName().substring(string.length()));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            CircusTranslatorApp.usage();
        }
        CircusTranslatorApp.loadMdl(stringArray[0]);
        CircusTranslatorApp.removePrefixFromSystemName("ProjetoPiloto");
        CircusTranslatorApp.initUI();
        CircusTranslatorApp.initSemantics();
    }

    static {
        GlobalErrorHandler.init();
        CircusTranslator.setSimplify(true);
    }
}

