/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortBlock;
import org.zeyda.clawcircus.collections.SignalSet;

public class TransUtils {
    public static String getVar(Port port) {
        String string;
        assert (port.isStandard());
        switch (port.getDir()) {
            case INPUT: {
                string = "In";
                break;
            }
            case OUTPUT: {
                string = "Out";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return string + port.getPortNum();
    }

    public static String getDecoVar(Port port) {
        String string;
        assert (port.isStandard());
        String string2 = TransUtils.getVar(port);
        switch (port.getDir()) {
            case INPUT: {
                string = "?";
                break;
            }
            case OUTPUT: {
                string = "!";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return string2 + string;
    }

    public static String createFlowName(Flow flow) {
        SignalSet signalSet = flow.getPOuts();
        assert (!signalSet.isEmpty());
        String string = "";
        if (signalSet.size() == 1) {
            string = ((Signal)signalSet.select()).getName();
        } else {
            assert (signalSet.size() >= 1);
            Signal signal = (Signal)signalSet.select();
            Block block = signal.getLink().getSrcBlock();
            boolean bl = true;
            for (Object object : signalSet) {
                if (((Signal)object).getLink().getSrcBlock().equals(block)) continue;
                bl = false;
                break;
            }
            if (bl) {
                string = block.getPath().getClawZName();
                string = string + "_out";
                boolean bl2 = true;
                for (Signal signal2 : signalSet) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        string = string + "_";
                    }
                    string = string + signal2.getLink().getSrcPort().getPortNum();
                }
            } else {
                string = "Flow";
                for (Object object : signalSet) {
                    for (Block block2 : ((Signal)object).getLink().getDstBlocks()) {
                        if (!block2.isOutport()) continue;
                        string = string + "_" + ((PortBlock)block2).getPortNum();
                    }
                }
            }
        }
        return string;
    }

    public static String breakDownNwayParallel(String string) {
        return string.replace("\\Parallel\\\\\n", "\\Parallel\n\\end{circus}\n\\vspace{-1ex}\n\n\\begin{circus}\n");
    }

    public static String adjustVerticalGaps(String string, String string2) {
        String string3 = "\\vspace{" + string2 + "}";
        string = string.replace("\\end{circus}\n\n", "\\end{circus}\n" + string3 + "\n\n");
        string = string.replace("\\end{circusaction}\n\n", "\\end{circusaction}\n" + string3 + "\n\n");
        string = string.replace("\\end{schema}\n\n", "\\end{schema}\n" + string3 + "\n\n");
        return string;
    }

    public static String removeExplicitNewlines(String string) {
        string = string.replace("\\removenewline\n", "");
        return string;
    }

    public static String removeSurplusNewlines(String string) {
        while (string.contains("\n\n\n")) {
            string = string.replace("\n\n\n", "\n\n");
        }
        return string;
    }

    public static String removeSpaceBeforeLatexLineBreaks(String string) {
        while (string.contains(" \\\\")) {
            string = string.replace(" \\\\", "\\\\");
        }
        return string;
    }
}

