/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.exceptions.MdlSemanticException;
import org.zeyda.clawcircus.utils.StringUtils;

public class MdlUtils {
    public static String getStringAttribute(String string, MdlBlock mdlBlock) throws MdlSemanticException {
        String string2 = mdlBlock.getAttributeValue(string);
        if (string2 == null) {
            throw new MdlSemanticException("No " + string + " attribute present.", mdlBlock);
        }
        if (string2.length() >= 2 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
            string2 = StringUtils.unquote(string2);
        }
        return string2;
    }

    public static int getIntegerAttribute(String string, MdlBlock mdlBlock) throws MdlSemanticException {
        try {
            return Integer.parseInt(MdlUtils.getStringAttribute(string, mdlBlock));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MdlSemanticException("Error parsing number in " + string + " attribute.", mdlBlock);
        }
    }

    public static String filterOpMask(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '|' || c == ' ') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

