/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.utils;

import java.util.Iterator;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Link;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.collections.BlockList;
import org.zeyda.clawcircus.collections.LinkSet;
import org.zeyda.clawcircus.collections.impl.BlockListImpl;

public class DiagramUtils {
    public static Link connect(Port port, Port port2) {
        assert (port.isValid());
        assert (port.isOutput());
        assert (port2.isValid());
        assert (port2.isInput());
        assert (!port2.isConnected());
        Link link = port.isConnected() ? port.getLink() : new Link(port);
        link.attachToPort(port2);
        return link;
    }

    public static LinkSet getInnerLinks(SubSystem subSystem) {
        LinkSet linkSet = subSystem.getInternalLinks();
        Iterator iterator = linkSet.iterator();
        while (iterator.hasNext()) {
            if (!((Link)iterator.next()).getSrcBlock().isPort()) continue;
            iterator.remove();
        }
        return linkSet;
    }

    public static BlockList getSubordinateBlocksWithState(Block block) {
        BlockListImpl blockListImpl = new BlockListImpl();
        if (block.getProperty("state", Boolean.class).booleanValue()) {
            blockListImpl.add(block);
        }
        if (block.isSubSystem()) {
            for (Block block2 : ((SubSystem)block).getBlocks()) {
                blockListImpl.addAll(DiagramUtils.getSubordinateBlocksWithState(block2));
            }
        }
        return blockListImpl;
    }

    public static boolean hasSubordinateBlocksWithState(Block block) {
        if (block.getProperty("state", Boolean.class).booleanValue()) {
            return true;
        }
        if (block.isSubSystem()) {
            for (Block block2 : block.getChildren()) {
                if (!DiagramUtils.hasSubordinateBlocksWithState(block2)) continue;
                return true;
            }
        }
        return false;
    }
}

