/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox.st;

import java.util.ArrayList;
import java.util.List;
import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.Flow;
import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortDir;
import org.zeyda.clawcircus.Toolbox.st.SignalConnector;
import org.zeyda.clawcircus.utils.LatexUtils;
import org.zeyda.clawcircus.utils.TransUtils;

public class FlowConnector {
    private final BlockWiring block_wiring;
    private final Flow flow;
    private final Block block;

    public FlowConnector(BlockWiring blockWiring, Flow flow, Block block) {
        assert (blockWiring != null);
        assert (flow != null);
        assert (block != null);
        assert (blockWiring.getFlows().contains(flow));
        this.block_wiring = blockWiring;
        this.flow = flow;
        this.block = block;
    }

    public String getName() {
        return LatexUtils.encode(TransUtils.createFlowName(this.flow));
    }

    public List<SignalConnector> getInputs() {
        ArrayList<SignalConnector> arrayList = new ArrayList<SignalConnector>();
        int n = 1;
        for (Signal signal : this.block_wiring.getInps()) {
            if (signal != null && this.flow.getRInps().contains(signal)) {
                arrayList.add(new SignalConnector(signal, new Port(this.block, n, PortDir.INPUT)));
            }
            ++n;
        }
        return arrayList;
    }

    public List<SignalConnector> getOutputs() {
        ArrayList<SignalConnector> arrayList = new ArrayList<SignalConnector>();
        int n = 1;
        for (Signal signal : this.block_wiring.getOuts()) {
            if (signal != null && this.flow.getPOuts().contains(signal)) {
                arrayList.add(new SignalConnector(signal, new Port(this.block, n, PortDir.OUTPUT)));
            }
            ++n;
        }
        return arrayList;
    }

    public List<SignalConnector> getHide_inputs() {
        ArrayList<SignalConnector> arrayList = new ArrayList<SignalConnector>();
        int n = 1;
        for (Signal signal : this.block_wiring.getInps()) {
            if (signal != null && !this.flow.getRInps().contains(signal)) {
                arrayList.add(new SignalConnector(signal, new Port(this.block, n, PortDir.INPUT)));
            }
            ++n;
        }
        return arrayList;
    }

    public List<SignalConnector> getHide_outputs() {
        ArrayList<SignalConnector> arrayList = new ArrayList<SignalConnector>();
        int n = 1;
        for (Signal signal : this.block_wiring.getOuts()) {
            if (signal != null && !this.flow.getPOuts().contains(signal)) {
                arrayList.add(new SignalConnector(signal, new Port(this.block, n, PortDir.OUTPUT)));
            }
            ++n;
        }
        return arrayList;
    }

    public List<SignalConnector> getHide_all() {
        ArrayList<SignalConnector> arrayList = new ArrayList<SignalConnector>();
        arrayList.addAll(this.getHide_inputs());
        arrayList.addAll(this.getHide_outputs());
        return arrayList;
    }

    public static List<FlowConnector> createList(BlockWiring blockWiring, Block block) {
        ArrayList<FlowConnector> arrayList = new ArrayList<FlowConnector>();
        for (Flow flow : blockWiring.getFlows()) {
            arrayList.add(new FlowConnector(blockWiring, flow, block));
        }
        return arrayList;
    }
}

