/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox.st;

import java.util.ArrayList;
import java.util.List;
import org.zeyda.clawcircus.Data.ClaSP.BlockWiringType;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Toolbox.st.SignalConnector;
import org.zeyda.clawcircus.utils.LatexUtils;

public class BlockConnector {
    private final Block block;

    public BlockConnector(Block block) {
        assert (block != null);
        this.block = block;
    }

    public String getClawz_name() {
        return LatexUtils.encode(this.block.getClawZName());
    }

    public List<SignalConnector> getInterface() {
        return SignalConnector.createList(this.block.getBlockWiring().getInterface());
    }

    public boolean getIs_subsystem() {
        return this.block.isSubSystem();
    }

    public List<SignalConnector> getInternal_interface() {
        assert (this.block.isSubSystem());
        SubSystem subSystem = (SubSystem)this.block;
        return SignalConnector.createList(subSystem.getBlockWiring(BlockWiringType.INNER).getInterface());
    }

    public List<SignalConnector> getExternal_interface() {
        assert (this.block.isSubSystem());
        SubSystem subSystem = (SubSystem)this.block;
        return SignalConnector.createList(subSystem.getBlockWiring(BlockWiringType.OUTER).getInterface());
    }

    public static List<BlockConnector> createList(SubSystem subSystem) {
        ArrayList<BlockConnector> arrayList = new ArrayList<BlockConnector>();
        for (Block block : subSystem) {
            if (!block.getProperty("translatable", Boolean.class).booleanValue()) continue;
            arrayList.add(new BlockConnector(block));
        }
        return arrayList;
    }
}

