/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.antlr.stringtemplate.StringTemplate;
import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.ClaSP.BlockWiringType;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.PortDir;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Toolbox.st.BlockConnector;
import org.zeyda.clawcircus.Toolbox.st.FlowConnector;
import org.zeyda.clawcircus.Toolbox.st.SignalConnector;
import org.zeyda.clawcircus.Toolbox.st.StateInfoConnector;
import org.zeyda.clawcircus.collections.impl.SignalSetImpl;
import org.zeyda.clawcircus.resources.Resources;
import org.zeyda.clawcircus.utils.DiagramUtils;
import org.zeyda.clawcircus.utils.LatexUtils;
import org.zeyda.clawcircus.utils.TransUtils;

public class CircusTranslator {
    public static final String ADJUST_GAPS_VSPACE = "-4ex";
    private static boolean simplify;

    public static void setSimplify(boolean bl) {
        simplify = bl;
    }

    public static boolean getSimplify() {
        return simplify;
    }

    public static String translate(Block block) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        CircusTranslator.translate(block, printWriter);
        printWriter.flush();
        String string = stringWriter.toString();
        string = CircusTranslator.postProcessCircusLatex(string);
        string = CircusTranslator.wrapIntoLatexDocument(block, string);
        return string;
    }

    public static String translateAll(Block block) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        CircusTranslator.translateAll(block, printWriter);
        printWriter.flush();
        String string = stringWriter.toString();
        string = CircusTranslator.postProcessCircusLatex(string);
        string = CircusTranslator.wrapIntoLatexDocument(block, string);
        return string;
    }

    private static void translate(Block block, PrintWriter printWriter) {
        StringTemplate stringTemplate;
        assert (block.getProperty("translatable", Boolean.class).booleanValue());
        CircusTranslator.makeProcessSection(block, printWriter);
        if (block.isSubSystem() && ((SubSystem)block).isCentralised()) {
            stringTemplate = CircusTranslator.toChannelDeclST((SubSystem)block);
            printWriter.println();
            printWriter.println(stringTemplate.toString());
        }
        stringTemplate = CircusTranslator.toProcessST(block);
        String string = stringTemplate.toString();
        if (block.isSubSystem() && ((SubSystem)block).isParallel()) {
            string = TransUtils.breakDownNwayParallel(string);
        }
        printWriter.println();
        printWriter.println(string);
    }

    public static void translateAll(Block block, PrintWriter printWriter) {
        Object object;
        if (block.isSubSystem() && ((SubSystem)block).isParallel()) {
            CircusTranslator.makeChannelSection(block, printWriter);
            object = CircusTranslator.toChannelDeclST((SubSystem)block);
            printWriter.println();
            printWriter.println(object.toString());
        }
        if (block.isRoot()) {
            object = CircusTranslator.getTemplate("end_cycle_decl");
            printWriter.println();
            printWriter.println(object.toString());
        }
        if (block.isSubSystem() && ((SubSystem)block).isParallel()) {
            for (Block block2 : ((SubSystem)block).getBlocks()) {
                CircusTranslator.translateAll(block2, printWriter);
            }
        }
        if (block.getProperty("translatable", Boolean.class).booleanValue()) {
            CircusTranslator.translate(block, printWriter);
        }
    }

    private static StringTemplate toChannelDeclST(SubSystem subSystem) {
        StringTemplate stringTemplate = CircusTranslator.getTemplate("channel_decls");
        SignalSetImpl signalSetImpl = new SignalSetImpl();
        signalSetImpl.addAll(subSystem.getBlockWiring(BlockWiringType.INNER).getInps());
        signalSetImpl.addAll(subSystem.getBlockWiring(BlockWiringType.INNER).getOuts());
        if (subSystem.isParallel()) {
            signalSetImpl.addAll(DiagramUtils.getInnerLinks(subSystem).toSignalSet());
        }
        stringTemplate.setAttribute("channels", SignalConnector.createList(signalSetImpl));
        return stringTemplate;
    }

    private static StringTemplate toProcessST(Block block) {
        StringTemplate stringTemplate;
        BlockWiring blockWiring = block.getBlockWiring();
        if (block.isSubSystem()) {
            blockWiring = ((SubSystem)block).getBlockWiring(BlockWiringType.INNER);
        }
        if (block.isPrimitive() || block.isSubSystem() && ((SubSystem)block).isCentralised()) {
            stringTemplate = CircusTranslator.getTemplate("process_ctr");
        } else {
            assert (block.isSubSystem() && ((SubSystem)block).isParallel());
            stringTemplate = CircusTranslator.getTemplate("process_par");
        }
        stringTemplate.setAttribute("clawz_name", (Object)LatexUtils.encode(block.getClawZName()));
        if (stringTemplate.getName().equals("process_ctr")) {
            if (block.isOutport()) {
                stringTemplate.setAttribute("clawz_schema", (Object)CircusTranslator.getTemplate("output_schema"));
            }
            stringTemplate.setAttribute("inputs", SignalConnector.createList(blockWiring.getInps(), block, PortDir.INPUT));
            stringTemplate.setAttribute("outputs", SignalConnector.createList(blockWiring.getOuts(), block, PortDir.OUTPUT));
            stringTemplate.setAttribute("state", StateInfoConnector.createList(block));
            stringTemplate.setAttribute("flows", FlowConnector.createList(blockWiring, block));
        } else {
            assert (stringTemplate.getName().equals("process_par"));
            SubSystem subSystem = (SubSystem)block;
            stringTemplate.setAttribute("blocks", BlockConnector.createList(subSystem));
            stringTemplate.setAttribute("inner_signals", SignalConnector.createList(DiagramUtils.getInnerLinks(subSystem).toSignalSet()));
        }
        stringTemplate.setAttribute("simplify", (Object)simplify);
        return stringTemplate;
    }

    public static String wrapIntoLatexDocument(Block block, String string) {
        StringTemplate stringTemplate = Resources.LATEX_STG.getInstanceOf("latex_wrapper");
        stringTemplate.setAttribute("spec_name", (Object)LatexUtils.encode(block.getPath().toString()));
        stringTemplate.setAttribute("content", (Object)string);
        return stringTemplate.toString();
    }

    private static void makeProcessSection(Block block, PrintWriter printWriter) {
        StringTemplate stringTemplate = Resources.LATEX_STG.getInstanceOf("process_section");
        stringTemplate.setAttribute("proc_name", (Object)LatexUtils.encode(block.getPath().toString()));
        printWriter.println();
        printWriter.println(stringTemplate.toString());
    }

    private static void makeChannelSection(Block block, PrintWriter printWriter) {
        StringTemplate stringTemplate = Resources.LATEX_STG.getInstanceOf("channel_section");
        stringTemplate.setAttribute("proc_name", (Object)LatexUtils.encode(block.getPath().toString()));
        printWriter.println();
        printWriter.println(stringTemplate.toString());
    }

    private static void makeLine(PrintWriter printWriter) {
        StringTemplate stringTemplate = Resources.LATEX_STG.getInstanceOf("hline");
        printWriter.println();
        printWriter.println(stringTemplate.toString());
    }

    private static String postProcessCircusLatex(String string) {
        String string2 = string;
        string2 = TransUtils.removeExplicitNewlines(string2);
        string2 = TransUtils.removeSurplusNewlines(string2);
        string2 = TransUtils.removeSpaceBeforeLatexLineBreaks(string2);
        return string2;
    }

    private static StringTemplate getTemplate(String string) {
        return Resources.CIRCTRANS_STG.getInstanceOf(string);
    }

    static {
        CircusTranslator.setSimplify(false);
    }
}

