/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Toolbox;

import java.io.File;
import org.antlr.stringtemplate.StringTemplate;
import org.zeyda.clawcircus.Data.Diagram.BlockUtil;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockLibraryXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockTypeXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.BlockWiringXml;
import org.zeyda.clawcircus.IO.ClaSP.jaxb.ClaSPXml;
import org.zeyda.clawcircus.Toolbox.ClaSPLibrary;
import org.zeyda.clawcircus.resources.Resources;
import org.zeyda.clawcircus.utils.FileUtils;
import org.zeyda.clawcircus.utils.MiscUtils;

public class BlockTypesGen {
    private static final String ROOT_PKG = "org.zeyda.clawcircus";

    public static void invoke(String string, String string2, String string3) {
        ClaSPXml claSPXml = ClaSPLibrary.getClaSP();
        BlockLibraryXml blockLibraryXml = claSPXml.getBlockLibrary();
        for (BlockTypeXml blockTypeXml : blockLibraryXml.getBlockType()) {
            if (!blockTypeXml.isGenclass()) continue;
            String string4 = BlockUtil.convBlockTypeToClass(blockTypeXml.getName());
            BlockWiringXml blockWiringXml = blockTypeXml.getBlockWiring();
            Integer n = BlockTypesGen.processInpsOuts(blockWiringXml.getInps());
            Integer n2 = BlockTypesGen.processInpsOuts(blockWiringXml.getOuts());
            boolean bl = blockTypeXml.isTranslatable();
            boolean bl2 = blockTypeXml.isState();
            StringTemplate stringTemplate = Resources.GEN_STG.getInstanceOf("blocktypes");
            stringTemplate.setAttribute("pkg_name", (Object)string2);
            stringTemplate.setAttribute("cls_name", (Object)string4);
            stringTemplate.setAttribute("base", (Object)blockTypeXml.getBase());
            if (!string4.equals(blockTypeXml.getName())) {
                stringTemplate.setAttribute("block_type", (Object)blockTypeXml.getName());
            }
            stringTemplate.setAttribute("inputs", (Object)n);
            stringTemplate.setAttribute("outputs", (Object)n2);
            stringTemplate.setAttribute("varlength", (Object)(n == null || n2 == null ? 1 : 0));
            stringTemplate.setAttribute("translatable", (Object)bl);
            stringTemplate.setAttribute("state", (Object)bl2);
            String string5 = BlockTypesGen.makeOutputPath(string, string2, string4);
            System.out.println("writing " + string5);
            FileUtils.writeTextFile(string5, stringTemplate.toString());
        }
    }

    private static Integer processInpsOuts(String string) {
        Integer n;
        if (string != null) {
            string = string.trim().toLowerCase();
            assert (string.equals("varlength") || MiscUtils.canBeParsedAsInt(string));
            n = !string.equals("varlength") ? Integer.valueOf(Integer.parseInt(string)) : null;
        } else {
            n = 0;
        }
        return n;
    }

    private static String makeOutputPath(String string, String string2, String string3) {
        if ((string = string.trim()).endsWith(File.separator) && !string.equals(File.separator)) {
            string = string.substring(0, string.length() - File.separator.length());
        }
        return string + File.separator + string2.replace(".", File.separator) + File.separator + string3 + ".java";
    }
}

