/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Parser;

import org.zeyda.clawcircus.Parser.TokenType;

public class Token {
    public static final Token EOF_TOKEN = new Token(TokenType.EOF, 0);
    private TokenType type;
    private String text;
    private int line;

    public Token(TokenType tokenType, String string, int n) {
        this.type = tokenType;
        this.text = string;
        this.line = n;
    }

    public Token(TokenType tokenType, int n) {
        this(tokenType, null, n);
    }

    public TokenType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public int getLine() {
        return this.line;
    }

    public boolean isText() {
        return this.type == TokenType.TEXT;
    }

    public boolean isQuotedText() {
        return this.type == TokenType.QUOTED_TEXT;
    }

    public boolean isLCURLY() {
        return this.type == TokenType.LCURLY;
    }

    public boolean isRCURLY() {
        return this.type == TokenType.RCURLY;
    }

    public boolean isEOF() {
        return this.type == TokenType.EOF;
    }

    public boolean isValidName() {
        return this.isText();
    }

    public boolean isValidValue() {
        return this.isText() || this.isQuotedText();
    }

    public String toString() {
        String string;
        switch (this.type) {
            case TEXT: {
                string = this.text;
                break;
            }
            case QUOTED_TEXT: {
                string = this.text;
                break;
            }
            case LCURLY: {
                string = "{";
                break;
            }
            case RCURLY: {
                string = "}";
                break;
            }
            case EOF: {
                string = "EOF";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return string;
    }
}

