/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.IO;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class RedirectThread
extends Thread {
    protected InputStream from;
    protected OutputStream to;
    protected boolean silent;
    protected List<Integer> buffer;

    public RedirectThread(InputStream inputStream, OutputStream outputStream, boolean bl) {
        assert (inputStream != null);
        assert (outputStream != null);
        this.from = inputStream;
        this.to = outputStream;
        this.silent = bl;
        this.buffer = new ArrayList<Integer>();
    }

    public RedirectThread(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, false);
    }

    public RedirectThread(InputStream inputStream, boolean bl) {
        this(inputStream, System.out, bl);
    }

    public RedirectThread(InputStream inputStream) {
        this(inputStream, false);
    }

    @Override
    public void run() {
        try {
            int n = this.from.read();
            while (n != -1) {
                if (this.silent) {
                    this.buffer.add(n);
                } else {
                    this.to.write(n);
                }
                n = this.from.read();
            }
            this.to.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            for (int n : this.buffer) {
                this.to.write(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.buffer.clear();
    }

    public static RedirectThread create(InputStream inputStream, OutputStream outputStream) {
        RedirectThread redirectThread = new RedirectThread(inputStream, outputStream);
        redirectThread.start();
        return redirectThread;
    }

    public static RedirectThread create(InputStream inputStream, OutputStream outputStream, boolean bl) {
        RedirectThread redirectThread = new RedirectThread(inputStream, outputStream, bl);
        redirectThread.start();
        return redirectThread;
    }

    public static RedirectThread create(InputStream inputStream) {
        RedirectThread redirectThread = new RedirectThread(inputStream);
        redirectThread.start();
        return redirectThread;
    }

    public static RedirectThread create(InputStream inputStream, boolean bl) {
        RedirectThread redirectThread = new RedirectThread(inputStream, bl);
        redirectThread.start();
        return redirectThread;
    }
}

