/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Simulink;

import java.util.Iterator;
import org.zeyda.clawcircus.Data.Simulink.Formatting;
import org.zeyda.clawcircus.Data.Simulink.MdlAttribute;
import org.zeyda.clawcircus.Data.Simulink.MdlElement;
import org.zeyda.clawcircus.Data.Simulink.MdlElementList;
import org.zeyda.clawcircus.Data.Simulink.MdlElementListImpl;
import org.zeyda.clawcircus.misc.AnnotationInterface;
import org.zeyda.clawcircus.utils.StringUtils;

public class MdlBlock
extends MdlElement
implements AnnotationInterface<MdlBlock>,
Iterable<MdlElement> {
    protected final MdlElementList elements = new MdlElementListImpl();
    private MdlElement cache = null;
    private int max_length_name = 0;

    public MdlBlock(String string) {
        super(string);
    }

    public int getMaxLengthName() {
        return this.max_length_name;
    }

    public MdlAttribute getAttribute(String string) {
        string = string.trim();
        if (this.cache != null && this.cache.isAttribute() && this.cache.getName().equals(string)) {
            return (MdlAttribute)this.cache;
        }
        for (MdlElement mdlElement : this) {
            if (!mdlElement.isAttribute() || !mdlElement.getName().equals(string)) continue;
            this.cache = mdlElement;
            return (MdlAttribute)mdlElement;
        }
        return null;
    }

    public String getAttributeValue(String string) {
        MdlAttribute mdlAttribute = this.getAttribute(string);
        if (mdlAttribute != null) {
            return mdlAttribute.getValue();
        }
        return null;
    }

    public void setAttribute(String string, String string2) {
        MdlAttribute mdlAttribute = this.getAttribute(string);
        if (mdlAttribute != null) {
            mdlAttribute.setValue(string2);
        } else {
            this.add(new MdlAttribute(string, string2));
        }
    }

    public boolean hasAttribute(String string) {
        return this.getAttribute(string) != null;
    }

    public boolean removeAttribute(String string) {
        MdlAttribute mdlAttribute = this.getAttribute(string);
        if (mdlAttribute != null) {
            return this.remove(mdlAttribute);
        }
        return false;
    }

    public MdlBlock getBlock(String string) {
        string = string.trim();
        if (this.cache != null && this.cache.isBlock() && this.cache.getName().equals(string)) {
            return (MdlBlock)this.cache;
        }
        for (MdlElement mdlElement : this) {
            if (!mdlElement.isBlock() || !mdlElement.getName().equals(string)) continue;
            this.cache = mdlElement;
            return (MdlBlock)mdlElement;
        }
        return null;
    }

    public boolean containsBlock(String string) {
        return this.getBlock(string) != null;
    }

    public boolean removeBlock(String string) {
        MdlBlock mdlBlock = this.getBlock(string);
        if (mdlBlock != null) {
            return this.remove(mdlBlock);
        }
        return false;
    }

    public void add(MdlElement mdlElement) {
        assert (mdlElement != null);
        assert (!mdlElement.hasParent());
        this.elements.add(mdlElement);
        mdlElement.setParent(this);
        if (mdlElement.isAttribute() && mdlElement.getName().length() > this.max_length_name) {
            this.max_length_name = mdlElement.getName().length();
        }
    }

    public boolean remove(MdlElement mdlElement) {
        boolean bl = this.elements.remove(mdlElement);
        if (bl) {
            mdlElement.setParent(null);
            this.recalcMaxLengthName();
        }
        return bl;
    }

    public String getBlockPath() {
        assert (this.getName().equals("Block") || this.getName().equals("System"));
        if (this.getName().equals("System")) {
            if (this.hasParent() && !this.getParent().getName().equals("Model")) {
                return this.getParent().getBlockPath();
            }
            return this.getAttributeValue("Name");
        }
        String string = "";
        if (this.hasParent()) {
            string = StringUtils.removeQuotes(this.getParent().getBlockPath()) + "/";
        }
        string = string + StringUtils.removeQuotes(this.getAttributeValue("Name"));
        string = StringUtils.addQuotes(string);
        return string;
    }

    public boolean isBlockType(String string) {
        assert (this.getName().equals("Block"));
        if (this.hasAttribute("BlockType")) {
            return this.getAttributeValue("BlockType").equals(string);
        }
        return false;
    }

    protected void recalcMaxLengthName() {
        this.max_length_name = 0;
        for (MdlElement mdlElement : this) {
            if (!mdlElement.isAttribute() || mdlElement.getName().length() <= this.max_length_name) continue;
            this.max_length_name = mdlElement.getName().length();
        }
    }

    @Override
    public String serialise() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName() + " {\n");
        String string = Formatting.getTabSpace(this.getLevel() + 1);
        for (MdlElement mdlElement : this) {
            stringBuilder.append(string + mdlElement.serialise() + "\n");
        }
        stringBuilder.append(Formatting.getTabSpace(this.getLevel()) + "}");
        return stringBuilder.toString();
    }

    @Override
    public Class<MdlBlock> getAnnotationKey() {
        return MdlBlock.class;
    }

    @Override
    public Iterator<MdlElement> iterator() {
        return this.elements.listIterator();
    }

    @Override
    public Object clone() {
        MdlBlock mdlBlock = (MdlBlock)super.clone();
        mdlBlock.elements.clear();
        for (MdlElement mdlElement : this.elements) {
            this.elements.add((MdlElement)mdlElement.clone());
        }
        return mdlBlock;
    }
}

