/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Diagram;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Link;
import org.zeyda.clawcircus.Data.Diagram.PortDir;
import org.zeyda.clawcircus.Data.Diagram.PortType;
import org.zeyda.clawcircus.utils.StringUtils;

public final class Port {
    private final Block block;
    private final int port_num;
    private final PortType type;
    private final PortDir dir;

    protected Port(Block block, int n, PortType portType, PortDir portDir) {
        assert (block != null);
        assert (portType != null);
        assert (portType.isStandard() && n >= 1 || portType.isSpecial() && n == 0);
        assert (portDir != null);
        this.block = block;
        this.port_num = n;
        this.type = portType;
        this.dir = portDir;
    }

    public Port(Block block, int n, PortDir portDir) {
        this(block, n, PortType.STANDARD, portDir);
    }

    public Port(Block block, PortType portType, PortDir portDir) {
        this(block, 0, portType, portDir);
    }

    public Block getBlock() {
        return this.block;
    }

    public int getPortNum() {
        assert (this.isStandard());
        return this.port_num;
    }

    public PortType getType() {
        return this.type;
    }

    public PortDir getDir() {
        return this.dir;
    }

    public boolean isValid() {
        if (this.type.isStandard()) {
            switch (this.dir) {
                case INPUT: {
                    return this.port_num >= 1 && this.port_num <= this.block.getInputPortsNum();
                }
                case OUTPUT: {
                    return this.port_num >= 1 && this.port_num <= this.block.getOutputPortsNum();
                }
            }
            throw new AssertionError();
        }
        assert (this.port_num == 0);
        return true;
    }

    public Link getLink() {
        assert (this.isValid());
        if (this.type.isStandard()) {
            switch (this.dir) {
                case INPUT: {
                    return this.block.getIncomingLink(this.port_num);
                }
                case OUTPUT: {
                    return this.block.getOutgoingLink(this.port_num);
                }
            }
            throw new AssertionError();
        }
        switch (this.dir) {
            case INPUT: {
                return this.block.getSpecialIncomingLink(this.type);
            }
            case OUTPUT: {
                return this.block.getSpecialOutgoingLink(this.type);
            }
        }
        throw new AssertionError();
    }

    public boolean isStandard() {
        return this.type.isStandard();
    }

    public boolean isSpecial() {
        return this.type.isSpecial();
    }

    public boolean isInput() {
        return this.dir == PortDir.INPUT;
    }

    public boolean isOutput() {
        return this.dir == PortDir.OUTPUT;
    }

    public boolean isEnable() {
        return this.type == PortType.ENABLE;
    }

    public boolean isTrigger() {
        return this.type == PortType.TRIGGER;
    }

    public boolean isAction() {
        return this.type == PortType.ACTION;
    }

    public boolean isConnected() {
        assert (this.isValid());
        return this.getLink() != null;
    }

    public boolean equals(Object object) {
        if (object instanceof Port) {
            Port port = (Port)object;
            return this.block.equals(port.block) && this.port_num == port.port_num && this.type == port.type && this.dir == port.dir;
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.block.hashCode() ^ new Integer(this.port_num).hashCode() ^ this.type.hashCode() ^ this.dir.hashCode();
    }

    public String toString() {
        String string;
        switch (this.type) {
            case STANDARD: {
                string = "";
                break;
            }
            case ENABLE: {
                string = "Enable";
                break;
            }
            case TRIGGER: {
                string = "Trigger";
                break;
            }
            case ACTION: {
                string = "Action";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        switch (this.dir) {
            case INPUT: {
                string = string + "In";
                break;
            }
            case OUTPUT: {
                string = string + "Out";
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (this.type.isStandard()) {
            return StringUtils.quote(this.block.getName()) + "." + string + this.port_num;
        }
        return StringUtils.quote(this.block.getName()) + "." + string;
    }
}

