/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Diagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.utils.ClawZUtils;

public class Path
extends ArrayList<Block>
implements Comparable<Path> {
    public Path() {
    }

    public Path(Block block) {
        for (Block block2 = block; block2 != null; block2 = block2.getParent()) {
            this.add(block2);
        }
        Collections.reverse(this);
    }

    public int length() {
        return this.size();
    }

    public Path subtract(Path path) {
        int n;
        for (n = 0; n < this.size() && n != path.size() && ((Block)this.get(n)).equals(path.get(n)); ++n) {
        }
        Path path2 = new Path();
        while (n < this.size()) {
            path2.add(this.get(n));
            ++n;
        }
        return path2;
    }

    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Block block : this) {
            if (!bl) {
                stringBuilder.append(string);
            }
            stringBuilder.append(ClawZUtils.toClawZName(block.getName()));
            bl = false;
        }
        return stringBuilder.toString();
    }

    public String getClawZName() {
        return this.toString("__");
    }

    public String getZSelectionStmt() {
        return this.toString(".");
    }

    @Override
    public int compareTo(Path path) {
        Iterator iterator = this.iterator();
        Iterator iterator2 = path.iterator();
        while (iterator.hasNext() || iterator2.hasNext()) {
            Block block;
            if (!iterator.hasNext()) {
                assert (iterator2.hasNext());
                return -1;
            }
            if (!iterator2.hasNext()) {
                assert (iterator.hasNext());
                return 1;
            }
            Block block2 = (Block)iterator.next();
            if (block2.equals(block = (Block)iterator2.next())) continue;
            return block2.compareTo(block);
        }
        return 0;
    }

    @Override
    public String toString() {
        return this.toString("/");
    }
}

