/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Diagram;

import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.collections.BlockList;
import org.zeyda.clawcircus.collections.BlockSet;
import org.zeyda.clawcircus.collections.PortSet;
import org.zeyda.clawcircus.collections.impl.BlockListImpl;
import org.zeyda.clawcircus.collections.impl.BlockSetImpl;
import org.zeyda.clawcircus.collections.impl.PortSetImpl;

public class Link {
    protected Port src_port = null;
    protected final PortSet dst_ports = new PortSetImpl();
    protected final Signal signal = new Signal(this);

    public Link() {
    }

    public Link(Port ... portArray) {
        this();
        this.attachToPorts(portArray);
    }

    public Port getSrcPort() {
        return this.src_port;
    }

    public boolean isSrcConnected() {
        return this.src_port != null;
    }

    public PortSet getDstPorts() {
        return this.dst_ports;
    }

    public boolean hasDstPorts() {
        return !this.dst_ports.isEmpty();
    }

    public Block getSrcBlock() {
        if (this.src_port == null) {
            return null;
        }
        return this.src_port.getBlock();
    }

    public BlockSet getDstBlocks() {
        BlockSetImpl blockSetImpl = new BlockSetImpl();
        for (Port port : this.dst_ports) {
            blockSetImpl.add(port.getBlock());
        }
        return blockSetImpl;
    }

    public PortSet getConnectedPorts() {
        PortSetImpl portSetImpl = new PortSetImpl();
        portSetImpl.add(this.getSrcPort());
        portSetImpl.addAll(this.getDstPorts());
        return portSetImpl;
    }

    public BlockList getConnectedBlocks() {
        BlockListImpl blockListImpl = new BlockListImpl();
        if (this.isSrcConnected()) {
            blockListImpl.add(this.getSrcBlock());
        }
        blockListImpl.addAll(this.getDstBlocks());
        return blockListImpl;
    }

    public void attachToPort(Port port) {
        port.getBlock().attachLink(this, port);
        switch (port.getDir()) {
            case OUTPUT: {
                assert (!this.isSrcConnected());
                this.src_port = port;
                break;
            }
            case INPUT: {
                this.dst_ports.add(port);
            }
        }
    }

    public void detachFromPort(Port port) {
        port.getBlock().detachLink(this, port);
        switch (port.getDir()) {
            case OUTPUT: {
                assert (this.isSrcConnected());
                this.src_port = null;
                break;
            }
            case INPUT: {
                assert (this.dst_ports.contains(port));
                this.dst_ports.remove(port);
            }
        }
    }

    public void attachToPorts(Port ... portArray) {
        for (Port port : portArray) {
            this.attachToPort(port);
        }
    }

    public void detachFromPorts(Port ... portArray) {
        for (Port port : portArray) {
            this.detachFromPort(port);
        }
    }

    public void detachAll() {
        this.detachFromPorts(this.getConnectedPorts().toArray(new Port[0]));
    }

    public Signal getSignal() {
        return this.signal;
    }

    public String toString() {
        return this.src_port.toString() + " -> " + this.dst_ports.toString();
    }
}

