/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Data.Diagram;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.zeyda.clawcircus.Data.ClaSP.BlockWiring;
import org.zeyda.clawcircus.Data.Diagram.BlockComparator;
import org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.ActionPort;
import org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.EnablePort;
import org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.Inport;
import org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.Outport;
import org.zeyda.clawcircus.Data.Diagram.BlockTypes.gen.TriggerPort;
import org.zeyda.clawcircus.Data.Diagram.Link;
import org.zeyda.clawcircus.Data.Diagram.Path;
import org.zeyda.clawcircus.Data.Diagram.Port;
import org.zeyda.clawcircus.Data.Diagram.PortBlock;
import org.zeyda.clawcircus.Data.Diagram.PortDir;
import org.zeyda.clawcircus.Data.Diagram.PortType;
import org.zeyda.clawcircus.Data.Diagram.SubSystem;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.collections.BlockList;
import org.zeyda.clawcircus.collections.LinkSet;
import org.zeyda.clawcircus.collections.PortSet;
import org.zeyda.clawcircus.collections.impl.LinkSetImpl;
import org.zeyda.clawcircus.collections.impl.PortSetImpl;
import org.zeyda.clawcircus.exceptions.MdlSemanticException;
import org.zeyda.clawcircus.misc.AnnotationInterface;
import org.zeyda.clawcircus.utils.ClaSPUtils;
import org.zeyda.clawcircus.utils.MdlUtils;
import org.zeyda.clawcircus.utils.MiscUtils;
import org.zeyda.clawcircus.utils.StringUtils;

public abstract class Block
implements Iterable<Block>,
Comparable<Block> {
    protected String name;
    protected SubSystem parent;
    protected Link[] incoming_links;
    protected Link[] outgoing_links;
    protected Map<PortType, Link> special_incoming_links;
    protected Map<PortType, Link> special_outgoing_links;
    protected Map<String, Object> properties;
    protected Map<Class, Object> annotations;

    protected Block(int n, int n2) {
        this.createLinks(n, n2);
        this.properties = new HashMap<String, Object>();
        this.annotations = new HashMap<Class, Object>();
    }

    protected Block() {
        this(0, 0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public SubSystem getParent() {
        return this.parent;
    }

    public void setParent(SubSystem subSystem) {
        assert (!this.hasParent());
        this.parent = subSystem;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean isRoot() {
        return !this.hasParent();
    }

    private void createLinks(int n, int n2) {
        this.incoming_links = new Link[n + 1];
        this.outgoing_links = new Link[n2 + 1];
        this.special_incoming_links = new EnumMap<PortType, Link>(PortType.class);
        this.special_outgoing_links = new EnumMap<PortType, Link>(PortType.class);
    }

    protected void updateIncomingLinks(int n) {
        Link[] linkArray = new Link[n + 1];
        System.arraycopy(this.incoming_links, 0, linkArray, 0, Math.min(this.incoming_links.length, linkArray.length));
        this.incoming_links = linkArray;
    }

    protected void updateOutgoingLinks(int n) {
        Link[] linkArray = new Link[n + 1];
        System.arraycopy(this.outgoing_links, 0, linkArray, 0, Math.min(this.outgoing_links.length, linkArray.length));
        this.outgoing_links = linkArray;
    }

    protected void updateLinks(int n, int n2) {
        this.updateIncomingLinks(n);
        this.updateOutgoingLinks(n2);
    }

    public void initialise() throws MdlSemanticException {
        if (this.hasAnnotation(MdlBlock.class)) {
            int n;
            String string;
            MdlBlock mdlBlock = this.getAnnotation(MdlBlock.class);
            this.setName(MdlUtils.getStringAttribute("Name", mdlBlock));
            if (this.hasProperty("infer_inputs_dynamically") && this.getProperty("infer_inputs_dynamically", Boolean.class).booleanValue()) {
                string = MdlUtils.getStringAttribute("Inputs", mdlBlock);
                n = MiscUtils.canBeParsedAsInt(string) ? Integer.parseInt(string) : MdlUtils.filterOpMask(string).length();
                this.updateIncomingLinks(n);
            }
            if (this.hasProperty("infer_outputs_dynamically") && this.getProperty("infer_outputs_dynamically", Boolean.class).booleanValue()) {
                string = MdlUtils.getStringAttribute("Outputs", mdlBlock);
                n = MiscUtils.canBeParsedAsInt(string) ? Integer.parseInt(string) : MdlUtils.filterOpMask(string).length();
                this.updateOutgoingLinks(n);
            }
        }
    }

    public Link[] getIncomingLinks() {
        return this.incoming_links;
    }

    public Link[] getOutgoingLinks() {
        return this.outgoing_links;
    }

    public Link getIncomingLink(int n) {
        assert (n >= 1 && n <= this.incoming_links.length);
        return this.incoming_links[n];
    }

    public Link getOutgoingLink(int n) {
        assert (n >= 1 && n <= this.outgoing_links.length);
        return this.outgoing_links[n];
    }

    public Link getSpecialIncomingLink(PortType portType) {
        return this.special_incoming_links.get((Object)portType);
    }

    public Link getSpecialOutgoingLink(PortType portType) {
        return this.special_outgoing_links.get((Object)portType);
    }

    public Link setSpecialIncomingLink(PortType portType, Link link) {
        assert (link != null);
        return this.special_incoming_links.put(portType, link);
    }

    public Link setSpecialOutgoingLink(PortType portType, Link link) {
        assert (link != null);
        return this.special_outgoing_links.put(portType, link);
    }

    public LinkSet getAllIncomingLinks() {
        LinkSetImpl linkSetImpl = new LinkSetImpl();
        for (Link link : this.incoming_links) {
            linkSetImpl.addIfNotNull(link);
        }
        linkSetImpl.addAll(this.special_incoming_links.values());
        return linkSetImpl;
    }

    public LinkSet getAllOutgoingLinks() {
        LinkSetImpl linkSetImpl = new LinkSetImpl();
        for (Link link : this.outgoing_links) {
            linkSetImpl.addIfNotNull(link);
        }
        linkSetImpl.addAll(this.special_outgoing_links.values());
        return linkSetImpl;
    }

    public LinkSet getAllLinks() {
        LinkSetImpl linkSetImpl = new LinkSetImpl();
        linkSetImpl.addAll(this.getAllIncomingLinks());
        linkSetImpl.addAll(this.getAllOutgoingLinks());
        return linkSetImpl;
    }

    public Link getUniqueLink() {
        assert (this.getInputPortsNum() + this.getOutputPortsNum() == 1);
        if (this.getInputPortsNum() == 1) {
            return this.getIncomingLink(1);
        }
        assert (this.getOutputPortsNum() == 1);
        return this.getOutgoingLink(1);
    }

    public void attachLink(Link link, Port port) {
        assert (link != null);
        assert (port.isValid());
        assert (port.getBlock().equals(this));
        assert (!port.isConnected());
        if (port.isStandard()) {
            switch (port.getDir()) {
                case INPUT: {
                    this.incoming_links[port.getPortNum()] = link;
                    break;
                }
                case OUTPUT: {
                    this.outgoing_links[port.getPortNum()] = link;
                }
            }
        }
        if (port.isSpecial()) {
            switch (port.getDir()) {
                case INPUT: {
                    this.special_incoming_links.put(port.getType(), link);
                    break;
                }
                case OUTPUT: {
                    this.special_outgoing_links.put(port.getType(), link);
                }
            }
        }
    }

    public void detachLink(Link link, Port port) {
        assert (port.isValid());
        assert (port.getBlock().equals(this));
        assert (port.isConnected());
        if (port.isStandard()) {
            switch (port.getDir()) {
                case INPUT: {
                    assert (this.incoming_links[port.getPortNum()] == link);
                    this.incoming_links[port.getPortNum()] = null;
                    break;
                }
                case OUTPUT: {
                    assert (this.outgoing_links[port.getPortNum()] == link);
                    this.outgoing_links[port.getPortNum()] = null;
                }
            }
        }
        if (port.isSpecial()) {
            switch (port.getDir()) {
                case INPUT: {
                    assert (this.special_incoming_links.get((Object)port.getType()) == link);
                    this.special_incoming_links.put(port.getType(), null);
                    break;
                }
                case OUTPUT: {
                    assert (this.special_outgoing_links.get((Object)port.getType()) == link);
                    this.special_outgoing_links.put(port.getType(), null);
                }
            }
        }
    }

    public void detachLink(Port port) {
        assert (port.isValid());
        assert (port.getBlock().equals(this));
        assert (port.isConnected());
        if (port.isStandard()) {
            switch (port.getDir()) {
                case INPUT: {
                    this.incoming_links[port.getPortNum()] = null;
                    break;
                }
                case OUTPUT: {
                    this.outgoing_links[port.getPortNum()] = null;
                }
            }
        } else {
            assert (port.isSpecial());
            switch (port.getDir()) {
                case INPUT: {
                    this.special_incoming_links.put(port.getType(), null);
                    break;
                }
                case OUTPUT: {
                    this.special_outgoing_links.put(port.getType(), null);
                }
            }
        }
    }

    public int getInputPortsNum() {
        return this.incoming_links.length - 1;
    }

    public int getOutputPortsNum() {
        return this.outgoing_links.length - 1;
    }

    public Port getInputPort(int n) {
        assert (n >= 1 && n <= this.getInputPortsNum());
        return new Port(this, n, PortDir.INPUT);
    }

    public Port getOutputPort(int n) {
        assert (n >= 1 && n <= this.getOutputPortsNum());
        return new Port(this, n, PortDir.OUTPUT);
    }

    public Port getInputPort(PortType portType) {
        assert (portType.isSpecial());
        return new Port(this, portType, PortDir.INPUT);
    }

    public Port getOutputPort(PortType portType) {
        assert (portType.isSpecial());
        return new Port(this, portType, PortDir.OUTPUT);
    }

    public PortSet getInputPorts() {
        PortSetImpl portSetImpl = new PortSetImpl();
        for (int i = 1; i <= this.getInputPortsNum(); ++i) {
            portSetImpl.add(this.getInputPort(i));
        }
        for (PortType portType : this.special_incoming_links.keySet()) {
            portSetImpl.add(this.getInputPort(portType));
        }
        return portSetImpl;
    }

    public PortSet getOutputPorts() {
        PortSetImpl portSetImpl = new PortSetImpl();
        for (int i = 1; i <= this.getOutputPortsNum(); ++i) {
            portSetImpl.add(this.getOutputPort(i));
        }
        for (PortType portType : this.special_outgoing_links.keySet()) {
            portSetImpl.add(this.getOutputPort(portType));
        }
        return portSetImpl;
    }

    public PortSet getAllPorts() {
        PortSetImpl portSetImpl = new PortSetImpl();
        portSetImpl.addAll(this.getInputPorts());
        portSetImpl.addAll(this.getOutputPorts());
        return portSetImpl;
    }

    public PortSet getConnectedPorts(Link link) {
        int n;
        PortSetImpl portSetImpl = new PortSetImpl();
        for (n = 1; n <= this.getInputPortsNum(); ++n) {
            if (link != this.incoming_links[n]) continue;
            portSetImpl.add(new Port(this, n, PortDir.INPUT));
        }
        for (n = 1; n <= this.getOutputPortsNum(); ++n) {
            if (link != this.outgoing_links[n]) continue;
            portSetImpl.add(new Port(this, n, PortDir.OUTPUT));
        }
        for (Map.Entry<PortType, Link> entry : this.special_incoming_links.entrySet()) {
            if (link != entry.getValue()) continue;
            portSetImpl.add(new Port(this, entry.getKey(), PortDir.INPUT));
        }
        for (Map.Entry<PortType, Link> entry : this.special_outgoing_links.entrySet()) {
            if (link != entry.getValue()) continue;
            portSetImpl.add(new Port(this, entry.getKey(), PortDir.OUTPUT));
        }
        return portSetImpl;
    }

    public Port resolveIntoPort() {
        assert (this.isPort());
        if (this.hasParent()) {
            return this.getParent().resolveIntoPort(this);
        }
        return null;
    }

    public boolean connects(Link link) {
        return !this.getConnectedPorts(link).isEmpty();
    }

    public final BlockWiring getBlockWiring() {
        if (!this.hasAnnotation(BlockWiring.class)) {
            this.setAnnotation(this.calcBlockWiring());
        }
        return this.getAnnotation(BlockWiring.class);
    }

    public BlockWiring calcBlockWiring() {
        return ClaSPUtils.calcBlockWiringFromLib(this);
    }

    public void clearAllBlockWiring() {
        this.removeAnnotation(BlockWiring.class);
        for (Block block : this.getChildren()) {
            block.clearAllBlockWiring();
        }
    }

    public Path getPath() {
        return new Path(this);
    }

    public String getClawZName() {
        return this.getPath().getClawZName();
    }

    public String getBlockType() {
        return this.getClass().getSimpleName();
    }

    public abstract BlockList getChildren();

    public boolean isPrimitive() {
        return !this.isSubSystem();
    }

    public boolean isPort() {
        return this instanceof PortBlock;
    }

    public boolean isSubSystem() {
        return this instanceof SubSystem;
    }

    public final boolean isInport() {
        return this instanceof Inport;
    }

    public final boolean isOutport() {
        return this instanceof Outport;
    }

    public final boolean isEnablePort() {
        return this instanceof EnablePort;
    }

    public final boolean isTriggerPort() {
        return this instanceof TriggerPort;
    }

    public final boolean isActionPort() {
        return this instanceof ActionPort;
    }

    public Object getProperty(String string) {
        assert (string != null);
        return this.properties.get(string);
    }

    public <T> T getProperty(String string, Class<T> clazz) {
        assert (string != null);
        Object object = this.properties.get(string);
        if (object == null) assert (false) : "Property " + string + " not assigned in block " + this.toString() + ".";
        assert (clazz.isAssignableFrom(object.getClass()));
        return (T)object;
    }

    public <T> void setProperty(String string, T t) {
        assert (string != null);
        this.properties.put(string, t);
    }

    public boolean hasProperty(String string) {
        return this.properties.containsKey(string);
    }

    public <T> T getAnnotation(Class<T> clazz) {
        Object object = this.annotations.get(clazz);
        if (object != null) assert (clazz.isAssignableFrom(object.getClass()));
        return (T)object;
    }

    public <T> void setAnnotation(AnnotationInterface<T> annotationInterface) {
        assert (annotationInterface != null);
        assert (annotationInterface.getAnnotationKey().isAssignableFrom(annotationInterface.getClass()));
        this.annotations.put(annotationInterface.getAnnotationKey(), annotationInterface);
    }

    public <T> void setAnnotation(Class<T> clazz, Object object) {
        assert (object != null);
        assert (clazz.isAssignableFrom(object.getClass()));
        this.annotations.put(clazz, object);
    }

    public void setAnnotation(Object object) {
        this.setAnnotation(object.getClass(), object);
    }

    public boolean hasAnnotation(Class clazz) {
        return this.annotations.containsKey(clazz);
    }

    public void removeAnnotation(Class clazz) {
        this.annotations.remove(clazz);
    }

    public TreePath getTreePath() {
        if (this.hasParent()) {
            return this.getParent().getTreePath().pathByAddingChild(this);
        }
        return new TreePath(this);
    }

    public void updateUI() {
        for (Block block : this.getChildren()) {
            block.updateUI();
        }
        this.notifyUI();
    }

    protected void notifyUI() {
        this.notifyUI(this.getTreePath(), this);
    }

    private void notifyUI(TreePath treePath, Block block) {
        if (this.hasAnnotation(TreeModel.class)) {
            this.getAnnotation(TreeModel.class).valueForPathChanged(treePath, block);
        }
        if (this.hasParent()) {
            super.notifyUI(treePath, block);
        }
    }

    @Override
    public Iterator<Block> iterator() {
        return this.getChildren().iterator();
    }

    @Override
    public int compareTo(Block block) {
        Block block2 = this;
        if (!block2.getBlockType().equals(block.getBlockType())) {
            Integer n = BlockComparator.BLOCK_TYPES_ORDER.get(block2.getBlockType());
            Integer n2 = BlockComparator.BLOCK_TYPES_ORDER.get(block.getBlockType());
            if (n == null && n2 == null) {
                return block2.getBlockType().compareTo(block.getBlockType());
            }
            if (n == null) {
                assert (n2 != null);
                return 1;
            }
            if (n2 == null) {
                assert (n != null);
                return -1;
            }
            return n - n2;
        }
        if (!block2.getName().equals(block.getName())) {
            return block2.getName().compareTo(block.getName());
        }
        return block2.hashCode() - block.hashCode();
    }

    public String toString() {
        return (this.name == null ? "<?>" : StringUtils.quote(this.getName())) + " " + "(" + this.getBlockType() + "/" + "[" + this.getInputPortsNum() + "," + this.getOutputPortsNum() + "])";
    }
}

