/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.Data.ClawZ.LibraryMetaFile;
import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Toolbox.MdlClawZAdaptor;
import org.zeyda.clawcircus.Toolbox.SimulinkAnalyser;
import org.zeyda.clawcircus.utils.AppUtils;
import org.zeyda.clawcircus.utils.FileUtils;

class SimulinkAnalyserApp {
    SimulinkAnalyserApp() {
    }

    private static void welcome() {
        AppUtils.makeWelcome("Simulink Analyser");
    }

    private static void usage() {
        System.out.println("Usage: analyse <file>.mdl [<file1>.lmf <file2>.lmf ..]");
        System.exit(-1);
    }

    private static void doAnalysis(MdlBlock mdlBlock, LibraryMetaFile[] libraryMetaFileArray) {
        MdlClawZAdaptor.invoke(mdlBlock);
        SimulinkAnalyser.useColouredOutput(true);
        SimulinkAnalyser.invoke(mdlBlock, libraryMetaFileArray);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            SimulinkAnalyserApp.usage();
        }
        SimulinkAnalyserApp.welcome();
        System.out.println("Analysing Simulink file: " + stringArray[0]);
        MdlBlock mdlBlock = FileUtils.readMdl(stringArray[0]);
        LibraryMetaFile[] libraryMetaFileArray = new LibraryMetaFile[stringArray.length - 1];
        for (int i = 1; i < stringArray.length; ++i) {
            System.out.println("Validating against " + stringArray[i]);
            libraryMetaFileArray[i - 1] = FileUtils.readLmf(stringArray[i]);
        }
        System.out.println("---");
        SimulinkAnalyserApp.doAnalysis(mdlBlock, libraryMetaFileArray);
    }
}

