/*
 * Decompiled with CFR 0.152.
 */
package org.zeyda.clawcircus.Application;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;
import org.zeyda.clawcircus.Toolbox.MdlClawZAdaptor;
import org.zeyda.clawcircus.utils.AppUtils;
import org.zeyda.clawcircus.utils.FileUtils;
import org.zeyda.clawcircus.utils.ParserUtils;

public class MdlClawZAdaptorApp {
    private static void welcome() {
        AppUtils.makeWelcome("Simulink Mdl Adaptor for ClawZ");
    }

    private static void usage() {
        System.out.println("Usage: adaptmdl <input file>.mdl <output file>.mdl");
        System.out.println("-> Note that the output file if exists will be silently overwritten.");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            MdlClawZAdaptorApp.usage();
        }
        MdlClawZAdaptorApp.welcome();
        System.out.println("Reading from input file: " + stringArray[0]);
        String string = FileUtils.readTextFile(stringArray[0]);
        System.out.println("Parsing model..");
        MdlBlock mdlBlock = ParserUtils.parseMdl(string);
        MdlClawZAdaptor.enableVerboseOutput();
        MdlClawZAdaptor.invoke(mdlBlock);
        System.out.println("Writing modifications to output file: " + stringArray[1]);
        FileUtils.writeMdl(stringArray[1], mdlBlock);
    }
}

