package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.Diagram.Block;
import org.zeyda.clawcircus.Data.Diagram.PortBlock;
import org.zeyda.clawcircus.Data.Diagram.Port;

import org.zeyda.clawcircus.Data.ClaSP.Signal;
import org.zeyda.clawcircus.Data.ClaSP.Flow;

import org.zeyda.clawcircus.collections.*;
import org.zeyda.clawcircus.collections.impl.*;

public class TransUtils {
   public static String getVar(Port port) {
      assert port.isStandard() /*&& port.isConnected()*/;
      String var_name;
      switch(port.getDir()) {
         case INPUT:
            var_name = "In";
            break;

         case OUTPUT:
            var_name = "Out";
            break;

         default:
            throw new AssertionError();
      }
      return var_name + port.getPortNum();
   }

   public static String getDecoVar(Port port) {
      assert port.isStandard() /*&& port.isConnected()*/;
      String var_name = getVar(port);
      String deco_suffix;
      switch(port.getDir()) {
         case INPUT:
            deco_suffix = "?";
            break;

         case OUTPUT:
            deco_suffix = "!";
            break;

         default:
            throw new AssertionError();
      }
      return var_name + deco_suffix;
   }

   /* Review and test the following method. */

   public static String createFlowName(Flow flow) {
      SignalSet pouts = flow.getPOuts();
      assert !pouts.isEmpty();
      String result = "";
      if (pouts.size() == 1) {
         result = pouts.select().getName();
      }
      else {
         /* The following code hasn't been tested yet. */
         assert pouts.size() >= 1;
         Signal specimen = pouts.select();
         Block src_block = specimen.getLink().getSrcBlock();
         boolean same_src = true;
         for(Signal out : pouts) {
            if (!out.getLink().getSrcBlock().equals(src_block)) {
               same_src = false;
               break;
            }
         }
         if (same_src) {
            result = src_block.getPath().getClawZName();
            result += "_out";
            boolean first = true;
            for(Signal out : pouts) {
               if (first) {
                  first = false;
               }
               else {
                  result += "_";
               }
               result += out.getLink().getSrcPort().getPortNum();
            }
         }
         else {
            /* This case may occur when looking at the inner wiring of a
             * subsystem. What naming convention to adopt here is still a
             * bit unsure. */
            result = "Flow";
            /* Flow must have originated from subsystem here. */
            for(Signal out : pouts) {
               for(Block dst_block : out.getLink().getDstBlocks()) {
                  if (dst_block.isOutport()) {
                     result += "_" + ((PortBlock) dst_block).getPortNum();
                  }
               }
            }
            /* More systematic solution which however produces long names. */
            /*boolean first = true;
            for(Signal out : pouts) {
               if (first) {
                  first = false;
               }
               else {
                  result += "_";
               }
               result += out.getName();
            }*/
         }
      }
      return result;
   }

   public static String breakDownNwayParallel(String circus_latex) {
      final String BREAKAT_STR = "\\Parallel\\\\\n";
      final String REPLACE_STR =
         "\\Parallel\n\\end{circus}\n\\vspace{-1ex}\n\n\\begin{circus}\n";
      return circus_latex.replace(BREAKAT_STR, REPLACE_STR);
   }

   public static String adjustVerticalGaps(String circus_latex, String amount)
   {
      String VSPACE_STR = "\\vspace{" + amount + "}";
      circus_latex = circus_latex.replace(
         "\\end{circus}\n\n",
         "\\end{circus}\n" + VSPACE_STR + "\n\n");
      circus_latex = circus_latex.replace(
         "\\end{circusaction}\n\n",
         "\\end{circusaction}\n" + VSPACE_STR + "\n\n");
      circus_latex = circus_latex.replace(
         "\\end{schema}\n\n",
         "\\end{schema}\n" + VSPACE_STR + "\n\n");
      return circus_latex;
   }

   public static String removeExplicitNewlines(String circus_latex) {
      circus_latex = circus_latex.replace("\\removenewline\n", "");
      return circus_latex;
   }

   public static String removeSurplusNewlines(String circus_latex) {
      while(circus_latex.contains("\n\n\n")) {
         circus_latex = circus_latex.replace("\n\n\n", "\n\n");
      }
      return circus_latex;
   }

   public static String removeSpaceBeforeLatexLineBreaks(String circus_latex) {
      while(circus_latex.contains(" \\\\")) {
         circus_latex = circus_latex.replace(" \\\\", "\\\\");
      }
      return circus_latex;
   }
}
