package org.zeyda.clawcircus.utils;

import java.util.List;
import java.util.Set;
import java.util.Collection;

public class StringUtils {
   public static String escape(String str) {
      str = str.replace("\\","\\\\");
      str = str.replace("\n","\\n");
      str = str.replace("\r","\\r");
      str = str.replace("\t","\\t");
      str = str.replace("\b","\\b");
      str = str.replace("\f","\\f");
      str = str.replace("\"","\\\"");
      str = str.replace("\'","\\\'");
      return str;
   }

   public static String unescape(String str) {
      str = str.replace("\\\\","\\");
      str = str.replace("\\n","\n");
      str = str.replace("\\r","\r");
      str = str.replace("\\t","\t");
      str = str.replace("\\b","\b");
      str = str.replace("\\f","\f");
      str = str.replace("\\\"","\"");
      str = str.replace("\\\'","\'");
      return str;
   }

   public static String quote(String str) {
      return "\"" + escape(str) + "\"";
   }

   public static String unquote(String str) {
      assert str.charAt(0) == '\"';
      assert str.charAt(str.length()-1) == '\"';
      return unescape(removeQuotes(str));
   }

   public static String addQuotes(String str) {
      return '\"' + str + '\"';
   }

   public static String removeQuotes(String str) {
      assert str.charAt(0) == '\"';
      assert str.charAt(str.length()-1) == '\"';
      return str.substring(1, str.length()-1);
   }

   public static String joinQuoted(String str1, String str2) {
      return addQuotes(removeQuotes(str1) + removeQuotes(str2));
   }

   public static <T> String toString(Collection<T> list, String left_delim,
      String right_delim, String comma) {
      StringBuilder result = new StringBuilder();
      result.append(left_delim);
      boolean first_iter = true;
      for(T element : list) {
         if (first_iter) {
            first_iter = false;
         }
         else {
            result.append(comma);
         }
         result.append(element);
      }
      result.append(right_delim);
      return result.toString();
   }

   public static <T> String toString(List<T> list) {
      return toString(list, "<", ">", ", ");
   }

   public static <T> String toString(Set<T> list) {
      return toString(list, "{", "}", ", ");
   }
}
