package org.zeyda.clawcircus.utils;

public class PrintUtils {
   private static String esc(String str) {
      return (char) 27 + str;
   }

   public static String intoBold(String str) {
      return esc("[1m") + str + esc("[0m");
   }

   public static String intoUnderline(String str) {
      return esc("[4m") + str + esc("[0m");
   }

   public static String intoRed(String str) {
      return esc("[31m") + str + esc("[0m");
   }

   public static String intoGreen(String str) {
      return esc("[32m") + str + esc("[0m");
   }

   public static String intoBlue(String str) {
      return esc("[34m") + str + esc("[0m");
   }

   public static String getIndentSpace(int level, int spaces) {
      StringBuilder result = new StringBuilder();
      for(int count = 0; count < level*spaces; count++) {
         result.append(" ");
      }
      return result.toString();
   }
}
