package org.zeyda.clawcircus.utils;

import org.zeyda.clawcircus.Data.ClawZ.LibraryMetaFile;

import org.zeyda.clawcircus.Data.Simulink.MdlBlock;

import org.zeyda.clawcircus.Parser.MdlLexer;
import org.zeyda.clawcircus.Parser.MdlParser;

import org.zeyda.clawcircus.exceptions.ParserException;

import java.util.List;

public class ParserUtils {
   public static MdlBlock parseMdl(String text) {
      MdlBlock model = null;
      try {
         MdlLexer lexer = new MdlLexer(text);
         MdlParser parser = new MdlParser(lexer);
         model = parser.parseMdl();
      }
      catch(ParserException e) {
         System.out.println(e.getMessage());
         System.exit(-1);
      }
      return model;
   }

   public static LibraryMetaFile parseLmf(String text) {
      List<MdlBlock> block_spec_list = null;
      try {
         MdlLexer lexer = new MdlLexer(text);
         MdlParser parser = new MdlParser(lexer);
         block_spec_list = parser.parseLmf();
      }
      catch(ParserException e) {
         System.out.println(e.getMessage());
         System.exit(-1);
      }
      return new LibraryMetaFile(block_spec_list);
   }
}
